package com.ydl.audioim.contract

import com.ydl.audioim.bean.ConnectBean
import com.ydl.audioim.http.command.*
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlcommon.mvp.base.BasePresenter
import com.ydl.ydlcommon.mvp.base.IModel
import com.ydl.ydlcommon.mvp.base.IPresenter
import com.ydl.ydlcommon.mvp.base.IView
import io.reactivex.Observable

/**
 * @author jiucheng
 * @描述:声网倾诉首页约束类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/10/30
 */
interface IAudioHomeActivityContract {
    interface View : IView {
        /**
         * 显示进度条
         */
        fun showProgressView()

        /**
         * 关闭进度条
         */
        fun dismissProgressView()

        /**
         * 关闭窗口
         */
        fun finishActivity()

        /**
         *切换axb回调
         */
        fun switchAXBResponse(axbPhone: String)

        /**
         * 跳转拨号页面
         */
        fun dialPhone()
    }


    interface Presenter : IPresenter<View> {
        /**
         * 登录信令
         */
        fun loginChatNet(signalingToken: String)

        /**
         * 获取axb电话
         */
        fun getAXBPhone(cmd: ConnectCommand)



        /**
         * 通话开始（更新专家状态）
         * @param param 请求参数
         */
//        fun connectStart(param: ConnectStartCommand)

        /**
         * 通话结束（更新专家状态）
         * @param param 请求参数
         */
//        fun connectFinish(param: ConnectFinishCommand)


        /**
         * 通知服务端发送推送
         */
        fun noticeServerPush(cmd: NoticePushCommand)
    }


    interface Model : IModel {
        /**
         * 获取axb电话
         */
        fun getAXBPhone(cmd: ConnectCommand): Observable<BaseAPIResponse<ConnectBean>>

        /**
         * 通话开始回调（更新专家状态）
         */
//        fun connectStart(param: ConnectStartCommand): Observable<BaseAPIResponse<Any>>

        /**
         * 通话结束（更新专家状态）
         */
//        fun connectFinish(param: ConnectFinishCommand): Observable<BaseAPIResponse<Any>>

        /**
         * 通话异常
         */
        fun connectException(param: ConnectExceptionCommand): Observable<BaseAPIResponse<Any>>


        /**
         * 通知服务端发送推送
         */
        fun noticeServerPush(param: NoticePushCommand): Observable<BaseResponse<Any>>
    }
}