package com.ydl.audioim.utils

import android.annotation.SuppressLint
import com.ydl.audioim.BuildConfig
import com.ydl.ydlcommon.base.BaseApp
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.yidianling.common.tools.LogUtil
import com.yidianling.common.tools.RxAppTool
import com.yidianling.common.tools.RxDeviceTool
import com.yidianling.common.tools.RxNetTool
import io.reactivex.Observable
import io.reactivex.schedulers.Schedulers
import java.io.BufferedWriter
import java.io.File
import java.io.FileWriter
import java.io.IOException
import java.text.SimpleDateFormat
import java.util.*

/**
 * @author jiucheng
 * @描述:记录声网双方信息相关的日志工具
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2020/2/12
 */
class AudioLogUtils {
    companion object {
        @SuppressLint("SimpleDateFormat")
         val format = SimpleDateFormat("yyyy-MM-dd HH:mm:ss")

        fun writeAgoraLog(content: String, fileName: String, isAppend: Boolean = true) {
            Observable.create<Any> {
                try {
                    writeLog(content, fileName, isAppend)
                    if (BuildConfig.DEBUG) {
                        LogUtil.d("writeLog_complete")
                    }
                } catch (e: Exception) {
                }
            }.subscribeOn(Schedulers.io())
                .subscribe()
        }

        private fun writeLog(content: String, fileName: String, isAppend: Boolean) {
            try {
                val folder = getLogFolder()
                val file = File(folder, fileName)
                if (!file.exists() || !file.isFile) {
                    file.createNewFile()
                }
                val fileWriter = FileWriter(file, true)
                val writer = BufferedWriter(fileWriter)
                if (!isAppend) {
                    writer.write("----------------")
                    writer.newLine()
//                    writer.write("""Time:${format.format(Calendar.getInstance().time)}""")
//                    writer.newLine()
//                    writer.write("ExpertUid = ${ModularServiceManager.getPlatformUserService()?.getUser()?.userId}")
//                    writer.newLine()
                    writer.write("""Network:${RxNetTool.getNetWorkTypeName(BaseApp.getApp())}""")
                    writer.newLine()
                    writer.write("""DevicesInfo:${RxDeviceTool.getBuildBrandModel()},${RxDeviceTool.getSDKVersionName()}""")
                    writer.newLine()
                    writer.write("""VersionInfo:${RxAppTool.getAppVersionName(BaseApp.getApp())}""")
                    writer.newLine()
                }
                writer.write(content)
                writer.newLine()
                writer.flush()
                writer.close()
            } catch (e: IOException) {
                e.printStackTrace()
            }
        }

        //获取app运行日志文件夹
        private fun getLogFolder(): File {
            val cacheDir = BaseApp.getApp().externalCacheDir.absolutePath
            val logFolder = File(cacheDir, "log")
            if (!logFolder.exists() || !logFolder.isDirectory) {
                logFolder.mkdir()
            }
            val folder = File(logFolder, "NewYdlApp")
            if (!folder.exists() || !folder.isDirectory) {
                folder.mkdir()
            }
            return folder
        }
    }
}