package com.ydl.consultantim.utils

import android.annotation.SuppressLint
import android.app.KeyguardManager
import android.content.Context
import android.os.PowerManager

/**
 * @author jiucheng
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2020/3/19
 */
class ConsultantAudioUtils {
   companion object{
       /**
        * 唤醒手机屏幕并解锁
        */
       @SuppressLint("InvalidWakeLockTag")
       fun wakeUpAndUnlock(context: Context) { // 获取电源管理器对象
           val pm = context.applicationContext
               .getSystemService(Context.POWER_SERVICE) as PowerManager
           val screenOn = pm.isScreenOn
           if (!screenOn) { // 获取PowerManager.WakeLock对象,后面的参数|表示同时传入两个值,最后的是LogCat里用的Tag
               val wl = pm.newWakeLock(
                   PowerManager.ACQUIRE_CAUSES_WAKEUP or
                           PowerManager.SCREEN_BRIGHT_WAKE_LOCK, "bright"
               )
               wl.acquire(10000) // 点亮屏幕
               wl.release() // 释放
           }
           // 屏幕解锁
           val keyguardManager =context.applicationContext
               .getSystemService(Context.KEYGUARD_SERVICE) as KeyguardManager
           val keyguardLock = keyguardManager.newKeyguardLock("unLock")
           // 屏幕锁定
           keyguardLock.reenableKeyguard()
           keyguardLock.disableKeyguard() // 解锁
       }
   }
}