package com.ydl.confide.home.adapter

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.View
import android.view.ViewGroup
import com.ydl.confide.R
import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.confide.home.config.IConfideHomeConfig
import com.ydl.confide.home.contract.IConfideHomeContract
import com.ydl.confide.home.event.IConfideHomeEvent
import com.ydl.confide.home.widget.*

/**
 * @author yuanwai
 * @描述:倾诉首页列表适配器（因为section框架有问题，故先改为传统方式编写）
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/12/14
 */
class ConfideHomeAdapter(private val mContext: Context,
                         private var confideHomeEvent: IConfideHomeEvent,
                         private var confideHomeView: IConfideHomeContract.View) : RecyclerView.Adapter<RecyclerView.ViewHolder>() {
    private var mListData: List<ConfideHomeDataBean>? = null

    private var mFilterViewHolder: FilterViewHolder? = null

    fun getFilterViewHolder(): FilterViewHolder? {
        return mFilterViewHolder
    }

    init {
        if (null == mListData) {
            mListData = ArrayList()
        }
    }

    override fun getItemViewType(position: Int): Int {
        if (null == mListData || mListData!!.isEmpty() || position >= mListData!!.size) {
            //当没数据 返回一个不存在的类型
            return 0
        }
        return mListData!![position].type!!
    }

    fun updataItems(list: List<ConfideHomeDataBean>) {
        if (null == mListData || mListData!!.isEmpty()) {
            mListData = ArrayList()
        } else {
            (mListData as ArrayList).clear()
        }
        (mListData as ArrayList).addAll(list)
    }

    fun addItems(list: List<ConfideHomeDataBean>) {
        if (null == mListData || mListData!!.isEmpty()) {
            mListData = ArrayList()
        }
        (mListData as ArrayList).addAll(list)
    }

    fun getList(): List<ConfideHomeDataBean>? {
        return mListData
    }

    fun getCount(): Int {
        if (null == mListData || mListData!!.isEmpty()) {
            return 0
        }
        return mListData!!.size
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        when (viewType) {
            //banner
            IConfideHomeConfig.TYPE_BANNER -> {
                return BannerViewHolder(ConfideHomeBannerView(parent.context, confideHomeEvent))
            }
            //最近倾诉
            IConfideHomeConfig.TYPE_RECENTLY_CONFIDED -> {
                return ConsultViewHolder(ConfideHomeRecentView(parent.context, confideHomeEvent))
            }
            //分类
            IConfideHomeConfig.TYPE_CATEGORY -> {
                return CategoryViewHolder(ConfideHomeCategoryView(parent.context, confideHomeEvent, confideHomeView))
            }
            //筛选模块
            IConfideHomeConfig.TYPE_RECOMMEND_FILTER -> {
                return FilterViewHolder(ConfideHomeFilterView(parent.context, confideHomeView))
            }
            //为你推荐
            IConfideHomeConfig.TYPE_RECOMMEND -> {
                return RecommendViewHolder(ConfideHomeRecommendView(confideHomeView, parent.context, confideHomeEvent))
            }
            //听声寻人
            IConfideHomeConfig.TYPE_SOUND -> {
                return ConfideHomeListenAndFoundViewHolder(ConfideHomeListenAndFoundView(parent.context, confideHomeEvent))
            }
            else -> {
                return EmptyViewHolder(View.inflate(parent.context, R.layout.confide_empty, null))
            }
        }
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) =
            if (holder is BannerViewHolder && null != holder.bannerView) {
                //banner
                holder.bannerView!!.initData(mListData!![position])
            } else if (holder is CategoryViewHolder && null != holder.categoryView) {
                //分类
                holder.categoryView!!.initData(mListData!![position])
            } else if (holder is FilterViewHolder && null != holder.filterView) {
                mFilterViewHolder = holder
                //筛选模块
                holder.filterView.initData(mListData!![position])
            } else if (holder is ConfideHomeListenAndFoundViewHolder) {
                //听声寻人
                holder.confideHomeListenAndFoundView!!.initData(mListData!![position])
            } else if (holder is ConsultViewHolder && null != holder.consultView) {
                //最近倾诉
                holder.consultView!!.initData(mListData!![position])
            } else if (holder is RecommendViewHolder && null != mListData!![position] && null != mListData!![position].body && !mListData!![position].body!!.isEmpty()) {
                //为你推荐
                holder.confideHomeRecommendView.initData(mListData!![position].body!![0], position, mListData!![position].recommendId)
            } else if (holder is EmptyViewHolder) {

            } else {

            }

    override fun getItemCount(): Int {
        return mListData!!.size
    }

    /**
     * banner viewHolder
     */
    inner class BannerViewHolder(itemView: ConfideHomeBannerView) : RecyclerView.ViewHolder(itemView) {
        var bannerView: ConfideHomeBannerView? = null

        init {
            bannerView = itemView
        }
    }

    /**
     * 分类测评 viewHolder
     */
    inner class CategoryViewHolder(itemView: ConfideHomeCategoryView) : RecyclerView.ViewHolder(itemView) {
        var categoryView: ConfideHomeCategoryView? = null

        init {
            categoryView = itemView
        }
    }

    /**
     * 筛选模块 viewHolder
     */
    inner class FilterViewHolder(var filterView: ConfideHomeFilterView) : RecyclerView.ViewHolder(filterView)

    /**
     * 听声寻人 viewHolder
     */
    inner class ConfideHomeListenAndFoundViewHolder(var confideHomeListenAndFoundView: ConfideHomeListenAndFoundView) : RecyclerView.ViewHolder(confideHomeListenAndFoundView)

    /**
     * 最近倾诉 viewHolder
     */
    inner class ConsultViewHolder(var consultView: ConfideHomeRecentView) : RecyclerView.ViewHolder(consultView)

    /**
     * 为你推荐 viewHolder
     */
    inner class RecommendViewHolder(var confideHomeRecommendView: ConfideHomeRecommendView) : RecyclerView.ViewHolder(confideHomeRecommendView)

    /**
     * 空ViewHolder
     */
    inner class EmptyViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var view: View? = null

        init {
            view = itemView
        }
    }
}