package com.ydl.confide.home.event

import android.view.View
import com.ydl.confide.home.adapter.ConfideHomeAdapter
import com.ydl.confide.home.bean.ConfideHomeAllFiltersBean
import com.ydl.confide.home.bean.ConfideHomeBodyBean
import com.ydl.confide.home.widget.ConfideHomeFilterView

/**
 * @author yuanwai
 * @描述:倾诉首页事件处理类接口
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/10
 */
interface IConfideHomeEvent {
    /**
     * 跳转我的
     */
    fun jumpMine()

    /**
     * banner点击事件
     * @param linkUrl 跳转地址
     * @param position 点击索引
     * @param title banner 标题
     */
    fun bannerClick(linkUrl: String?, position: Int?, title: String?)

    /**
     * 最近倾诉--继续倾诉
     * @param linkUrl 跳转地址
     */
    fun latelyConfideClick(linkUrl: String?)

    /**
     * 最近倾诉--更多
     * @param linkUrl 跳转地址
     */
    fun latelyConfideMore(linkUrl: String?)

    /**
     * 分类测评点击事件
     * @param linkUrl
     */
    fun categoryClick(linkUrl: String?)

    /**
     * 为你推荐--向TA倾诉
     * @param linkUrl 跳转地址
     */
    fun recommendClick(linkUrl: String?)

    /**
     * 为你推荐--更多
     * @param linkUrl 跳转地址
     */
    fun recommendMoreClick(linkUrl: String?)

    /**
     * 听声寻人--向TA倾诉
     * @param linkUrl 跳转地址
     */
    fun soundClick(linkUrl: String?)

    /**
     * 听声寻人--更多
     * @param linkUrl 跳转地址
     */
    fun soundMoreClick(linkUrl: String?)

    /**
     * 咨询师推荐--点我倾诉
     * @param linkUrl 跳转地址
     */
    fun consultantClick(linkUrl: String?)

    /**
     * 咨询师推荐--更多情感恋爱专家
     * @param linkUrl 跳转地址
     */
    fun consultantMoreClick(linkUrl: String?)

    /**
     * 播放音频
     * @param type    当前模块数据类型
     * @param index   当前的模块里的数据索引位置
     * @param playUrl 播放地址
     */
    fun playVoice(type: Int?, index: Int?, playUrl: String?)

    /**
     * 播放音频
     * @param type        当前模块数据类型
     * @param index       当前的模块里的数据索引位置
     * @param recommendId 为你推荐Id（用于区分播放区域）
     * @param playUrl     播放地址
     * @param name     咨询师姓名
     */
    fun playVoice(type: Int?, index: Int?, recommendId: Int, playUrl: String?, name: String?)

    /**
     * 重播
     */
    fun rePlayVoice()

    /**
     * 暂停播放
     */
    fun pauseVoice()

    /**
     * 结束播放 释放资源
     */
    fun destoryPlayer()

    /**
     * 私聊
     */
    fun toChatForMsg(doctorId: String?)

    /**
     * 排序弹窗
     */
    fun showSortPopupWindow(v_line_top: View, filterView: ConfideHomeFilterView, bodyBean: ConfideHomeBodyBean?, allFiltersBean: ConfideHomeAllFiltersBean, mConfideAdapter: ConfideHomeAdapter)

    /**
     * 性别年龄弹窗
     */
    fun showSexAgePopupWindow(v_line_top: View, filterView: ConfideHomeFilterView, bodyBean: ConfideHomeBodyBean?, allFiltersBean: ConfideHomeAllFiltersBean, mConfideAdapter: ConfideHomeAdapter)

    /**
     * 擅长方向弹窗
     */
    fun showGoodPopupWindow(v_line_top: View, filterView: ConfideHomeFilterView, bodyBean: ConfideHomeBodyBean?, allFiltersBean: ConfideHomeAllFiltersBean, mConfideAdapter: ConfideHomeAdapter)
}