package com.ydl.confide.home.http

import com.ydl.confide.home.bean.ConfideConnectResponse
import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.ydlcommon.base.config.YDL_DOMAIN
import com.ydl.ydlcommon.base.config.YDL_DOMAIN_JAVA
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import io.reactivex.Observable
import retrofit2.http.GET
import retrofit2.http.Headers
import retrofit2.http.QueryMap
import retrofit2.http.Url

/**
 * @author yuanwai
 * @描述:倾诉首页Api
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/10
 */
interface ConfideHomeApi{
    //倾诉首页
    @Headers( YDL_DOMAIN + YDL_DOMAIN_JAVA,"Content-Type:application/json")
    @GET
    fun confideHome(@Url url: String): Observable<BaseAPIResponse<MutableList<ConfideHomeDataBean>>>

    //每日精选 换一批
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_JAVA,"Content-Type:application/json")
    @GET
    fun recommedChange(@Url url: String): Observable<BaseAPIResponse<ConfideHomeDataBean>>

    //连接-java接口
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_JAVA,"Content-Type:application/json")
    @GET("auth/listen/dial")
    fun connectJava(@QueryMap params: Map<String, String>): Observable<BaseAPIResponse<ConfideConnectResponse>>
}