package com.ydl.confide.home.http

import com.ydl.confide.home.bean.ConfideConnectResponse
import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.confide.home.bean.ConnectParamJava
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import io.reactivex.Observable

/**
 * @author yuanwai
 * @描述:倾诉首页请求接口
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/7/26
 */
interface IConfideHomeHttp{
    /**
     * 倾诉首页请求
     */
    fun confideHomeRequest(): Observable<BaseAPIResponse<MutableList<ConfideHomeDataBean>>>

    /**
     * 为你推荐列表
     */
    fun recommendList(param : ConfideRecommendParam): Observable<BaseAPIResponse<ConfideHomeDataBean>>

    //倾诉链接，java接口，支持axb和声网
    fun connectionJava(connectParam: ConnectParamJava) : Observable<BaseAPIResponse<ConfideConnectResponse>>
}