package com.ydl.confide.home.model

import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.confide.home.contract.IConfideHomeContract
import com.ydl.confide.home.http.ConfideHomeDataManager
import com.ydl.confide.home.http.ConfideRecommendParam
import com.ydl.ydlcommon.data.http.RxUtils
import io.reactivex.Observable

/**
 * @author yuanwai
 * @描述:倾诉首页数据模型实现类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/10
 */
class ConfideHomeModelImpl : IConfideHomeContract.Model{

    override fun confideHomeRequest(): Observable<MutableList<ConfideHomeDataBean>> {
        return ConfideHomeDataManager.getHttp().confideHomeRequest()
                .compose(RxUtils.resultJavaData())
    }

    override fun recommendList(param : ConfideRecommendParam): Observable<ConfideHomeDataBean> {
        return ConfideHomeDataManager.getHttp().recommendList(param)
                .compose(RxUtils.resultJavaData())
    }
}