package com.ydl.confide.home.modular.service

import android.app.Activity
import android.app.Application
import android.content.Context
import android.content.Intent
import android.net.Uri
import androidx.fragment.app.DialogFragment
import android.text.TextUtils
import com.alibaba.android.arouter.facade.annotation.Route
import com.google.gson.Gson
import com.ydl.audioim.YDLavManager
import com.ydl.audioim.widget.AxbConfirmDialog
import com.ydl.confide.api.IConfideService
import com.ydl.confide.home.ConfideHomeActivity
import com.ydl.webview.TellData
import com.ydl.ydlcommon.base.BaseApp
import com.ydl.ydlcommon.base.config.YDLConstants
import com.ydl.ydlcommon.utils.YDLCacheUtils
import com.yidianling.common.tools.RxSPTool
import com.yidianling.common.tools.ToastUtil

/**
 * Created by haorui on 2019-12-11 .
 * Des:
 */
@Route(path = "/confide/ConfideService")
class ConfdieServiceImpl : IConfideService {

    override fun init(context: Context?) {

    }


    override fun phoneCallFragment(head: String, callId: String): DialogFragment {
        //废弃
        return DialogFragment()
    }

    override fun phoneCallIntent(activity: Activity): Intent {
        //废弃
        val intent = Intent(activity, ConfideHomeActivity::class.java)
        return intent
    }

    override fun openConfideHome(context: Context) {
        val intent = Intent(context, ConfideHomeActivity::class.java)
        if (context !is Activity) {
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
        }
        context.startActivity(intent)
    }

    override fun connectionJava(id: Int, type: Int, activity: Activity, tellData: String?, callType: String?) {
        val myTellData: TellData? = if (tellData == null ) null else Gson().fromJson(tellData, TellData::class.java)
        ConfideWebServiceImpl().connectionJava(id, type, activity, myTellData, callType)
    }

    override fun ydlAvManagerLogin(uid: String?) {
        YDLavManager.instances.login(uid)
    }

    override fun startCondifeHomePage(context: Context, isSplash: Boolean) {
        val intent1 = Intent(context, ConfideHomeActivity::class.java)
        intent1.putExtra("isSplash", isSplash)
        intent1.flags = Intent.FLAG_ACTIVITY_NEW_TASK
        context.startActivity(intent1)
    }

    override fun initYdlavManager(app: Application) {

        var avManagerKey = ""
        if (BaseApp.instance.getGlobalConfig().appDebug) {
            val appEnv = BaseApp.instance.getGlobalConfig().appEnv

            //debug包根据url判断使用正式或者测试key
            val cacheAppEnv = YDLCacheUtils.getCacheApi()
            if (!TextUtils.isEmpty(cacheAppEnv)) {
                if (YDLConstants.ENV_TEST == cacheAppEnv) {
                    avManagerKey = "13b1536698f64905a1e7e5bb978ba821"
                } else {
                    avManagerKey = "3387e9b251f3491e9221a9877e8f7830"
                }
            } else {
                if (YDLConstants.ENV_TEST == appEnv || YDLConstants.ENV_AUTO_TEST == appEnv) {
                    avManagerKey = "13b1536698f64905a1e7e5bb978ba821"
                } else {
                    avManagerKey = "3387e9b251f3491e9221a9877e8f7830"
                }
            }
        } else {
            //release包始终使用正式key
            avManagerKey = "3387e9b251f3491e9221a9877e8f7830"
        }

        YDLavManager.instances.init(app, avManagerKey)
    }

    override fun showAxbConfirmDialog(activity: Activity?, type: Int, phoneNumber: String?) {
        val dialog = AxbConfirmDialog(activity, type, object : AxbConfirmDialog.OnClickEnsureListener {
            override fun onClickEnsure() {
                phoneNumber?.let {
                    val phoneIntent = Intent(Intent.ACTION_DIAL, Uri.parse("tel:" + phoneNumber!!))
                    activity?.startActivity(phoneIntent)
                }
            }

            override fun onClose() {

            }
        })
        dialog.show()
    }

    override fun closePlayer() {

    }


}