package com.ydl.confide.home.section

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.View
import android.view.ViewGroup
import com.ydl.confide.R
import com.ydl.confide.home.config.IConfideHomeConfig
import com.ydl.confide.home.event.IConfideHomeEvent
import com.ydl.confide.home.widget.ConfideHomeFooterView
import com.ydl.ydlcommon.adapter.section.Section

/**
 * @author yuanwai
 * @描述:倾诉首页 底部 更多情感恋爱专家View 适配器
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/10 0010
 */
class ConfideHomeFooterSection(var context: Context, private var confideHomeEvent : IConfideHomeEvent) : Section<RecyclerView.ViewHolder>(0) {
    override fun getSectionId(): Int {
        return IConfideHomeConfig.SECTION_FOOTER
    }

    override fun getTotalDataNum(): Int {
        return 1
    }

    override fun getItemViewType(position: Int): Int {
        return IConfideHomeConfig.SECTION_FOOTER
    }

    override fun onCreateViewHolder(parent: ViewGroup?, viewType: Int): RecyclerView.ViewHolder {
        return when(viewType){
        //banner
            IConfideHomeConfig.SECTION_FOOTER -> {
                FooterViewHolder(ConfideHomeFooterView(context,confideHomeEvent))
            }
            else -> {
                EmptyViewHolder(View.inflate(context,R.layout.confide_view_empty,null))
            }
        }
    }

    override fun bindViewHolder(holder: RecyclerView.ViewHolder?, position: Int) {

    }

    override fun isBelongTo(viewType: Int): Boolean {
        return viewType.toString().startsWith(IConfideHomeConfig.SECTION_FOOTER.toString())
    }

    override fun isHeadType(position: Int): Boolean {
        return false
    }

    override fun isFooterType(position: Int): Boolean {
        return false
    }


    /**
     * 底部 更多情感恋爱专家 viewHolder
     */
    inner class FooterViewHolder(itemView: ConfideHomeFooterView) : RecyclerView.ViewHolder(itemView) {
        var footerView: ConfideHomeFooterView? = null

        init {
            footerView = itemView
        }
    }

    /**
     * 空View
     */
    inner class EmptyViewHolder(itemViews: View) :  RecyclerView.ViewHolder(itemViews) {
        private var itemViews: View? = null

        init {
            this.itemViews = itemViews
        }
    }
}