package com.ydl.confide.home.section

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.ViewGroup
import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.confide.home.config.IConfideHomeConfig
import com.ydl.confide.home.contract.IConfideHomeContract
import com.ydl.confide.home.event.IConfideHomeEvent
import com.ydl.confide.home.widget.ConfideHomeRecommendView
import com.ydl.ydlcommon.adapter.section.Section

/**
 * @author Jim
 * @描述:为你推荐section
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/11 0011
 */
class ConfideRecommendSection(var context: Context,var view: IConfideHomeContract.View, var confideHomeEvent: IConfideHomeEvent) : Section<RecyclerView.ViewHolder>(0) {
    override fun getSectionId(): Int {
        return IConfideHomeConfig.SECTION_RECOMMEND
    }

    private var data: ConfideHomeDataBean? = null

    fun setData(data: ConfideHomeDataBean) {
        this.data = data
    }

    fun addData(data: ConfideHomeDataBean){
        if (null == data || null == data.body){
            return
        }
        (this.data!!.body as ArrayList).addAll(data.body)
    }

    override fun bindViewHolder(holder: RecyclerView.ViewHolder?, position: Int) {
        if (holder is RecommendViewHolder) {
            holder.confideHomeRecommendView.initData(this.data!!.body!![position],position,data!!.recommendId)
        }
    }

    override fun getTotalDataNum(): Int {
        return data!!.body!!.size
    }

    override fun getItemViewType(position: Int): Int {
        return IConfideHomeConfig.SECTION_RECOMMEND
    }

    override fun onCreateViewHolder(parent: ViewGroup?, viewType: Int): RecyclerView.ViewHolder {
        return RecommendViewHolder(ConfideHomeRecommendView(view,context, confideHomeEvent))
    }

    override fun isBelongTo(viewType: Int): Boolean {
        return viewType.toString().startsWith(IConfideHomeConfig.SECTION_RECOMMEND.toString())
    }

    override fun isHeadType(position: Int): Boolean {
        return false
    }

    override fun isFooterType(position: Int): Boolean {
        return false
    }

    inner class RecommendViewHolder(var confideHomeRecommendView: ConfideHomeRecommendView) : RecyclerView.ViewHolder(confideHomeRecommendView)
}