package com.ydl.confide.home.widget

import android.content.Context
import androidx.annotation.Nullable
import androidx.cardview.widget.CardView
import android.text.TextUtils
import android.util.AttributeSet
import android.view.View
import com.ydl.confide.R
import com.ydl.confide.home.bean.ConfideHomeBodyBean
import com.ydl.confide.home.contract.IConfideHomeContract
import com.ydl.confide.home.event.IConfideHomeEvent
import com.ydl.ydl_image.module.GlideApp
import com.yidianling.common.tools.RxImageTool
import kotlinx.android.synthetic.main.confide_item_category.view.*

/**
 * @author yuanwai
 * @描述:倾诉首页--分类子View
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/21
 */
class ConfideHomeCategoryItemView(mContext: Context, @Nullable attrs: AttributeSet) : CardView(mContext, attrs) {

    private var confideHomeEvent: IConfideHomeEvent? = null

    private var dp35: Int = 0

    init {
        initView()
    }

    private fun initView() {
        View.inflate(context, R.layout.confide_item_category, this)
        dp35 = RxImageTool.dip2px(35f)
    }

    fun initData(bodyBean: ConfideHomeBodyBean?, confideHomeEvent: IConfideHomeEvent, homeView: IConfideHomeContract.View) {
        this.confideHomeEvent = confideHomeEvent
        if (null == bodyBean) {
            return
        }
        //这样处理 是防止 滑动过程中 反复去加载图片
        if (!TextUtils.isEmpty(bodyBean.categoryIcon) && img_icon.getTag(R.id.img_icon) != bodyBean.categoryIcon) {
            GlideApp.with(context)
                    .load(bodyBean.categoryIcon)
                    .override(dp35, dp35)
                    .into(img_icon)
            img_icon.setTag(R.id.img_icon, bodyBean.categoryIcon)
        }
        tv_title.text = bodyBean.categoryName
        tv_content.text = bodyBean.categoryContent
        setOnClickListener {
            //加载H5页面
            if (bodyBean.categoryType == 1) {
                //加载H5页面，跳转统一路由
                confideHomeEvent.categoryClick(bodyBean.linkUrl)
            } else if (bodyBean.categoryType == 2) {
                //锚点到筛选位置
                homeView.moveToFilter()

            }
        }
    }
}