package com.ydl.confide.home.widget

import android.content.Context
import android.view.View
import android.widget.FrameLayout
import com.ydl.confide.R
import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.confide.home.event.IConfideHomeEvent
import kotlinx.android.synthetic.main.confide_banner.view.*

/**
 * @author Jim
 * @描述:倾诉首页--听声寻人View
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/11 0011
 */
class ConfideHomeListenAndFoundView(context: Context, private var confideHomeEvent: IConfideHomeEvent) : FrameLayout(context) {

    private var selectIndex: Int = 0
    private var firstView: View? = null
    private var lastView: View? = null
    private var cacheList: ArrayList<View>? = null

    init {
        initView()
        cacheList = ArrayList()
    }

    private fun initView() {
        View.inflate(context, R.layout.confide_banner, this)
    }

    fun initData(bean: ConfideHomeDataBean) {
        if (bean == null || bean.body == null || bean.body.isEmpty()) {
            visibility = View.GONE
            return
        }
        visibility = View.VISIBLE
        for (index in 0 until bean.body.size) {
            if (bean.body[index].confideIsPlay) {
                if (index < bean.body.size) {
                    selectIndex = index + 1
                } else {
                    selectIndex = index
                }
            }

            if (index == 0) {
                if (null == firstView) {
                    //第一个View（用于左右滑动过度的View）
                    firstView = ConfideHomeListenAndFoundItemView(context, confideHomeEvent)
                }
                (firstView as ConfideHomeListenAndFoundItemView).initData(bean.body[index], index)
            }

            if (index == bean.body.size - 1) {
                if (null == lastView) {
                    //最后一个View（用于左右滑动过度的View）
                    lastView = ConfideHomeListenAndFoundItemView(context, confideHomeEvent)
                }
                (lastView as ConfideHomeListenAndFoundItemView).initData(bean.body[index], index)
            }
            //如果缓存为0 则新建View
            if (cacheList!!.size == 0) {
                //根据数据集合添加item view
                var view = ConfideHomeListenAndFoundItemView(context, confideHomeEvent)
                cacheList!!.add(view)
            } else if (index > cacheList!!.size - 1) {//如果索引大于缓存的大小 则新建View
                //根据数据集合添加item view
                var view = ConfideHomeListenAndFoundItemView(context, confideHomeEvent)
                cacheList!!.add(view)
            }
            //获取缓存相应索引位置的Item view 并初始化数据
            ((cacheList as ArrayList)[index] as ConfideHomeListenAndFoundItemView).initData(bean.body[index], index)
        }
        //给bannner设置数据
        confide_home_banner?.setView(cacheList, firstView, lastView)?.start()
        //设置上一次 点击播放的位置
        if (selectIndex == 0) {
            confide_home_banner.setCurrentItem(1)
        } else {
            confide_home_banner.setCurrentItem(selectIndex)
        }
    }
}