package com.ydl.confide.home.widget

import android.content.Context
import android.graphics.Color
import android.text.TextUtils
import android.util.TypedValue
import android.view.Gravity
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import android.widget.LinearLayout
import android.widget.TextView
import com.ydl.ydl_image.module.GlideApp
import com.yidianling.common.tools.RxImageTool
import com.ydl.confide.R
import com.ydl.confide.home.bean.ConfideHomeBodyBean
import com.ydl.confide.home.config.IConfideHomeConfig
import com.ydl.confide.home.event.IConfideHomeEvent
import com.ydl.ydlcommon.utils.ScreenUtil
import kotlinx.android.synthetic.main.confide_recommend_expert_item_view.view.*

/**
 * @author yuanwai
 * @描述:倾诉首页--最佳倾诉榜单item view
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/21
 */
class ConfideHomeRecommendExpertItemView(mContext: Context, private var confideHomeEvent: IConfideHomeEvent) : FrameLayout(mContext) {
    private var bgWidth: Int = 0
    private var dp100: Int = 0
    private var dp16 = 0
    private var dp4 = 0
    private var dp3 = 0

    init {
        initView()
    }

    private fun initView() {
        View.inflate(context, R.layout.confide_recommend_expert_item_view, this)
        bgWidth = ScreenUtil.screenWidth - RxImageTool.dip2px(30f)
        dp100 = RxImageTool.dip2px(100f)
        dp16 = RxImageTool.dip2px(16f)
        dp4 = RxImageTool.dip2px(4f)
        dp3 = RxImageTool.dip2px(3f)
    }

    fun initData(bodyBean: ConfideHomeBodyBean?, position: Int) {
        if (null == bodyBean || null == bodyBean.bodyData || bodyBean.bodyData!!.isEmpty()) {
            visibility = View.GONE
            return
        }
        var dataBean = bodyBean.bodyData!![0]
        visibility = View.VISIBLE
        //设置标题
        if (!TextUtils.isEmpty(bodyBean.confidedTitle)) {
            tv_title.text = bodyBean.confidedTitle
        }
        //设置背景图
        setBGUrl(bodyBean)
        //设置在线状态
        setLineStatu(dataBean)
        //设置头像
        setHead(dataBean)
        //设置播放状态
        setPlay(dataBean, bodyBean.confideIsPlay, position)
        //设置名称
        if (!TextUtils.isEmpty(dataBean.confidedName)) {
            tv_name.text = dataBean.confidedName
        }
        //设置性别
        setSex(dataBean)
        //设置向TA倾诉文案
        setConfideNum(dataBean)
        //设置接通率文案
        setConnection(dataBean)
        //设置标签
        setConfideTag(dataBean)
        //设置咨询师简介
        tv_content.text = dataBean.confideContent
        //设置按钮文案
        setConfideButton(dataBean)
        //点击事件
        setOnClickListener {
            click(dataBean)
        }
    }

    /**
     * 设置背景图片
     */
    private fun setBGUrl(bodyBean: ConfideHomeBodyBean) {
        //这样处理 是防止 滑动过程中 反复去加载图片
        if (!TextUtils.isEmpty(bodyBean.confideBgUrl) && img_bg.getTag(R.id.img_bg) != bodyBean.confideBgUrl) {
            GlideApp.with(context)
                    .load(bodyBean.confideBgUrl)
                    .override(bgWidth, RxImageTool.dip2px(250f))
                    .into(img_bg)
            img_bg.setTag(R.id.img_bg, bodyBean.confideBgUrl)
        }
    }

    /**
     * 设置在线状态
     */
    private fun setLineStatu(bodyBean: ConfideHomeBodyBean) {
        when (bodyBean.confideLine) {//1在线 2离线 3通话中 4继续通话
            1, 4 -> {
                tv_isLine.text = "在线"
                tv_isLine.setBackgroundResource(R.drawable.confide_bg_main_color)
            }
            2 -> {
                tv_isLine.text = "离线"
                tv_isLine.setBackgroundResource(R.drawable.confide_bg_color_666666)
            }
            3 -> {
                tv_isLine.text = "通话中"
                tv_isLine.setBackgroundResource(R.drawable.confide_bg_color_ff8f38)
            }
        }
    }

    /**
     * 设置头像
     */
    private fun setHead(bodyBean: ConfideHomeBodyBean) {
        //这样处理 是防止 滑动过程中 反复去加载图片
        if (!TextUtils.isEmpty(bodyBean.confidedIcon) && img_head.getTag(R.id.img_head) != bodyBean.confidedIcon) {
            GlideApp.with(context)
                    .load(bodyBean.confidedIcon)
                    .override(dp100, dp100)
                    .into(img_head)
            img_head.setTag(R.id.img_head, bodyBean.confidedIcon)
        }
    }

    /**
     * 设置播放按钮
     */
    private fun setPlay(bodyBean: ConfideHomeBodyBean, confideIsPlay: Boolean, position: Int) {
        if (TextUtils.isEmpty(bodyBean.confideVoice)) {
            img_play.visibility = View.GONE
        } else {
            img_play.visibility = View.VISIBLE
        }
        if (confideIsPlay) {
            img_play.setImageResource(R.drawable.confide_playing)
        } else {
            img_play.setImageResource(R.drawable.confide_sond_play)
        }
        img_play.setOnClickListener {
            if (confideIsPlay) {
                confideHomeEvent.pauseVoice()
            } else {
                confideHomeEvent.playVoice(IConfideHomeConfig.TYPE_CONSULTANT, position, bodyBean.confideVoice)
            }
        }
    }

    /**
     * 设置性别
     */
    private fun setSex(bodyBean: ConfideHomeBodyBean) {
        if (bodyBean.confideSex == 1) {
            img_sex.setImageResource(R.drawable.confide_new_male)
        } else {
            img_sex.setImageResource(R.drawable.confide_new_female)
        }
    }

    /**
     * 设置向TA倾诉文案
     */
    private fun setConfideNum(bodyBean: ConfideHomeBodyBean) {
        if (TextUtils.isEmpty(bodyBean.confideNum)) {
            tv_confideNum.visibility = View.GONE
            tv_tv_confideNumContent.visibility = View.GONE
        } else {
            tv_confideNum.visibility = View.VISIBLE
            tv_tv_confideNumContent.visibility = View.VISIBLE
            tv_confideNum.text = bodyBean.confideNum
        }
    }

    /**
     * 设置接通率文案
     */
    private fun setConnection(bodyBean: ConfideHomeBodyBean) {
        if (TextUtils.isEmpty(bodyBean.confideConnection)) {
            tv_Connection.visibility = View.GONE
            tv_ConnectionContent.visibility = View.GONE
        } else {
            tv_Connection.visibility = View.VISIBLE
            tv_ConnectionContent.visibility = View.VISIBLE
            tv_Connection.text = bodyBean.confideConnection
        }
    }

    /**
     * 设置标签 todo 待优化
     */
    private fun setConfideTag(bodyBean: ConfideHomeBodyBean) {
        flowlayout_tag.removeAllViews()
        if (null == bodyBean.confidedTag || bodyBean.confidedTag.isEmpty()) {
            return
        }
        var i = 0
        for (tag in bodyBean.confidedTag) {
            if (i > 4) break
            var params = LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, dp16)
            params.setMargins(0, 0, dp4, 0)
            var textView = TextView(context)
            textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 10f)
            textView.setTextColor(Color.parseColor("#808080"))
            textView.gravity = Gravity.CENTER
            textView.setPadding(dp3, 0, dp3, 0)
            textView.setBackgroundResource(R.drawable.confide_bg_tag)
            textView.layoutParams = params
            textView.text = tag
            flowlayout_tag.addView(textView)
            i++
        }
    }

    /**
     * 设置向TA倾诉按钮状态
     */
    private fun setConfideButton(bodyBean: ConfideHomeBodyBean) {
        when (bodyBean.confideLine) {//1在线 2离线 3通话中
            1, 3, 4 -> {
                tv_confide.text = "向TA倾诉"
            }
            2 -> {
                tv_confide.text = "喊TA上线"
            }
        }
    }

    /**
     * 点击事件
     */
    private fun click(bodyBean: ConfideHomeBodyBean) {
        when (bodyBean.confideLine) {//1在线 2离线 3通话中
            1, 3, 4 -> {
                confideHomeEvent.consultantClick(bodyBean.linkUrl)
            }
            2 -> {
                //跳转私聊 并发送自定义消息
                confideHomeEvent.toChatForMsg(""+bodyBean.uid)
            }
        }
    }
}