package com.ydl.confide.home.widget

import android.content.Context
import android.graphics.Color
import android.graphics.Paint
import android.text.TextUtils
import android.util.TypedValue
import android.view.Gravity
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import android.widget.LinearLayout
import android.widget.TextView
import com.ydl.ydl_image.module.GlideApp
import com.yidianling.common.tools.RxImageTool
import com.ydl.confide.R
import com.ydl.confide.home.bean.ConfideHomeBodyBean
import com.ydl.confide.home.config.IConfideHomeConfig
import com.ydl.confide.home.contract.IConfideHomeContract
import com.ydl.confide.home.event.IConfideHomeEvent
import kotlinx.android.synthetic.main.confide_recommend_view.view.*

/**
 * @author yuanwai
 * @描述:为你推荐
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/21 0011
 */
class ConfideHomeRecommendView(var view: IConfideHomeContract.View, context: Context, private var confideHomeEvent: IConfideHomeEvent) : FrameLayout(context) {

    private var dp96 = 0
    private var dp16 = 0
    private var dp4 = 0
    private var dp3 = 0

    init {
        initView()
    }

    private fun initView() {
        var params = FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        layoutParams = params
        View.inflate(context, R.layout.confide_recommend_view, this)
        dp96 = RxImageTool.dip2px(96f)
        dp16 = RxImageTool.dip2px(16f)
        dp4 = RxImageTool.dip2px(4f)
        dp3 = RxImageTool.dip2px(3f)
    }

    fun initData(bodyBean: ConfideHomeBodyBean?, position: Int, recommendId: Int) {
        if (bodyBean == null) {
            visibility = View.GONE
            return
        }
        var data = bodyBean
        //设置在线状态
        setLineStatu(bodyBean)
        //设置头像
        setHead(bodyBean)
        //设置播放按钮
        setPlay(bodyBean, position, recommendId)
        //设置名称
        tv_name.text = bodyBean.confidedName
        //设置性别
        setSex(bodyBean)
        //设置向TA倾诉文案
        setConfideNum(bodyBean)
        //设置接通率文案
        setConnection(bodyBean)
        //设置价格
        setPrice(bodyBean)
        //设置红包、原价
        setCoupon(bodyBean)
        //设置标签
        setConfideTag(bodyBean)
        //设置咨询师简介
        tv_content.text = bodyBean.confideContent
        //设置向TA倾诉按钮状态
        setConfideButton(bodyBean)
        //设置页面点击事件
        this.setOnClickListener {

            confideHomeEvent.consultantClick(bodyBean.linkUrl)
        }
    }

    /**
     * 设置在线状态
     */
    private fun setLineStatu(bodyBean: ConfideHomeBodyBean) {
        when (bodyBean.confideLine) {//1在线 2离线 3通话中
            1, 4 -> {
                tv_isLine.text = "在线"
                tv_isLine.setBackgroundResource(R.drawable.confide_bg_main_color)
            }
            2 -> {
                tv_isLine.text = "离线"
                tv_isLine.setBackgroundResource(R.drawable.confide_bg_color_666666)
            }
            3 -> {
                tv_isLine.text = "通话中"
                tv_isLine.setBackgroundResource(R.drawable.confide_bg_color_ff8f38)
            }
//            4 -> {
//                tv_confide.text = "继续倾诉"
//                tv_confide.setBackgroundResource(R.drawable.confidehome_recent_btn_continue_bg)
//            }
        }
    }

    /**
     * 设置头像
     */
    private fun setHead(bodyBean: ConfideHomeBodyBean) {
        //这样处理 是防止 滑动过程中 反复去加载图片
        if (!TextUtils.isEmpty(bodyBean.confidedIcon) && img_head.getTag(R.id.img_head) != bodyBean.confidedIcon) {
            GlideApp.with(context)
                    .load(bodyBean.confidedIcon)
                    .override(dp96, dp96)
                    .into(img_head)
            img_head.setTag(R.id.img_head, bodyBean.confidedIcon)
        }
    }

    /**
     * 设置播放按钮
     */
    private fun setPlay(bodyBean: ConfideHomeBodyBean, position: Int, recommendId: Int) {
        if (TextUtils.isEmpty(bodyBean.confideVoice)) {
            iv_play.visibility = View.GONE
        } else {
            iv_play.visibility = View.VISIBLE
        }
        if (bodyBean.confideIsPlay) {
            iv_play.setImageResource(R.drawable.confide_playing)
        } else {
            iv_play.setImageResource(R.drawable.confide_sond_play)
        }
        iv_play.setOnClickListener {
            if (bodyBean.confideIsPlay!!) {
                confideHomeEvent.pauseVoice()
            } else {
                confideHomeEvent.playVoice(IConfideHomeConfig.TYPE_RECOMMEND, position, recommendId, bodyBean.confideVoice, bodyBean.confidedName)
            }
        }
    }

    /**
     * 设置性别
     */
    private fun setSex(bodyBean: ConfideHomeBodyBean) {
        if (bodyBean.confideSex == 1) {
            img_sex.setImageResource(R.drawable.confide_new_male)
        } else {
            img_sex.setImageResource(R.drawable.confide_new_female)
        }
    }

    /**
     * 设置向TA倾诉文案
     */
    private fun setConfideNum(bodyBean: ConfideHomeBodyBean) {
        if (TextUtils.isEmpty(bodyBean.confideNum)) {
            tv_confideNum.visibility = View.GONE
            tv_tv_confideNumContent.visibility = View.GONE
        } else {
            tv_confideNum.visibility = View.VISIBLE
            tv_tv_confideNumContent.visibility = View.VISIBLE
            tv_confideNum.text = bodyBean.confideNum
        }
    }

    /**
     * 设置接通率文案
     */
    private fun setConnection(bodyBean: ConfideHomeBodyBean) {
        if (TextUtils.isEmpty(bodyBean.confideConnection)) {
            tv_Connection.visibility = View.INVISIBLE
            tv_ConnectionContent.visibility = View.INVISIBLE
        } else {
            tv_Connection.visibility = View.VISIBLE
            tv_ConnectionContent.visibility = View.VISIBLE
            tv_Connection.text = bodyBean.confideConnection
        }
    }

    /**
     * 设置价格
     */
    private fun setPrice(bodyBean: ConfideHomeBodyBean) {
        val sb = StringBuffer()
        if (TextUtils.isEmpty(bodyBean.confideFee)) {
            sb.append("0")
        } else {
            sb.append(bodyBean.confideFee)
        }
        tv_price.text = sb.toString()
    }

    /**
     * 设置标签 todo 待优化
     */
    private fun setConfideTag(bodyBean: ConfideHomeBodyBean) {
        flowlayout_tag.removeAllViews()
        if (null == bodyBean.confidedTag || bodyBean.confidedTag.isEmpty()) {
            return
        }
        var i = 0
        for (tag in bodyBean.confidedTag!!) {
            if (i > 4) break
            var params = LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, dp16)
            params.setMargins(0, 0, dp4, 0)
            var textView = TextView(context)
            textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 10f)
            textView.setTextColor(Color.parseColor("#808080"))
            textView.gravity = Gravity.CENTER
            textView.setPadding(dp3, 0, dp3, 0)
            textView.setBackgroundResource(R.drawable.confide_bg_tag)
            textView.layoutParams = params
            textView.text = tag
            flowlayout_tag.addView(textView)
            i++
        }
    }

    /**
     * 设置向TA倾诉按钮状态
     */
    private fun setConfideButton(bodyBean: ConfideHomeBodyBean) {
        when (bodyBean.confideLine) {//1在线 2离线 3通话中  4继续倾诉
            1 -> {
                tv_confide.setBackgroundResource(R.drawable.confide_line_1)
            }
            2 -> {
                tv_confide.setBackgroundResource(R.drawable.confide_line_2)
            }
            3 -> {
                tv_confide.setBackgroundResource(R.drawable.confide_line_3)
            }
            4 -> {
                tv_confide.setBackgroundResource(R.drawable.confide_line_4)
            }
        }
        tv_confide.setOnClickListener {
            click(bodyBean)
        }
    }

    /**
     * 设置红包、原价
     */
    private fun setCoupon(bodyBean: ConfideHomeBodyBean) {
        if (!TextUtils.isEmpty(bodyBean.couponText)) {
            tvCoupon.text = bodyBean.couponText
            tvCoupon.visibility = View.VISIBLE
        } else {
            tvCoupon.visibility = View.GONE
        }
        if (TextUtils.isEmpty(bodyBean.confideFee) || TextUtils.isEmpty(bodyBean.couponMoney) || bodyBean.couponMoney!!.toFloat() <= 0) {
            tvOriginalPrice.visibility = View.GONE
        } else {
            try {
                val couponMoney = bodyBean.couponMoney.toFloat().toInt()
                val confideFee = bodyBean.confideFee!!.toFloat().toInt()

                tvOriginalPrice.visibility = View.VISIBLE
                val originalBuffer = StringBuffer()
                originalBuffer.append(bodyBean.confideFee).append("元/次")
                tvOriginalPrice.text = originalBuffer.toString()
                //添加删除线
                tvOriginalPrice.paint.flags = Paint.STRIKE_THRU_TEXT_FLAG
                if (couponMoney >= confideFee) {
                    tv_price.text = "0"
                } else {
                    val price = confideFee - couponMoney
                    tv_price.text = price.toString()
                }
            } catch (e: Exception) {
                //防止数据类型变化引起奔溃
            }

        }
    }

    /**
     * 点击事件
     */
    private fun click(bodyBean: ConfideHomeBodyBean) {
        when (bodyBean.confideLine) {//1在线 2离线 3通话中
            1, 3, 4 -> {
                if (bodyBean.confideLine == 1) {
                }
                if (bodyBean.confideLine == 3) {
                }

                confideHomeEvent.consultantClick(bodyBean.linkUrl)
            }
            2 -> {
                //跳转私聊 并发送自定义消息
                confideHomeEvent.toChatForMsg("" + bodyBean.uid)
            }
        }
    }
}