package com.yidianling.consultant.adapter

import android.content.Context
import android.graphics.Typeface
import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.ydl.ydlcommon.adapter.MyBaseAdapter
import com.yidianling.consultant.R
import com.yidianling.consultant.model.bean.RegionItem
import kotlinx.android.synthetic.main.consultant_item_region.view.*

@Suppress("DEPRECATION")
/**
 * 省份列表适配器
 * Created by zqk on 17-7-21.
 */
class RegionRecyclerViewAdapter(val context: Context, val regionList: ArrayList<RegionItem>, var selectedRegion: RegionItem) : RecyclerView.Adapter<RegionRecyclerViewAdapter.ViewHolder>() {

    var onItemClickListener: MyBaseAdapter.OnItemClickListener<RegionItem>? = null

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        var region = RegionItem(ArrayList(), "全国", null)
        if (position > 0) {
            region = regionList[position - 1]
        }
        holder.itemView.tvRegionName.text = region.value
        if (selectedRegion.key == region.key) {
            //选中状态
            holder.itemView.tvRegionName.setTypeface(Typeface.DEFAULT_BOLD)
//                holder.itemView.tvRegionName.setBackgroundColor(Color.rgb(255, 255, 255))
            holder.itemView.tvRegionName.setTextColor(context.resources.getColor(R.color.platform_main_theme))
            holder.itemView.view_select.visibility = View.VISIBLE
        } else {
            //未选中状态
            holder.itemView.tvRegionName.setTypeface(Typeface.DEFAULT)
//                holder.itemView.tvRegionName.setBackgroundColor(Color.rgb(245, 245, 245))
            holder.itemView.tvRegionName.setTextColor(context.resources.getColor(R.color.platform_default_text_color))
            holder.itemView.view_select.visibility = View.INVISIBLE
        }
    }

    override fun getItemCount(): Int = regionList.size + 1

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val view = LayoutInflater.from(context).inflate(R.layout.consultant_item_region, parent, false)
        return ViewHolder(view)
    }

    inner class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        init {
            itemView.setOnClickListener {
                val position = adapterPosition
                if (position != RecyclerView.NO_POSITION) {
                    selectedRegion = if (position == 0) {
                        RegionItem(ArrayList(), "全国", null)
                    } else {
                        regionList[position - 1]
                    }
                    notifyDataSetChanged()
                    onItemClickListener?.onItemClickListener(itemView, adapterPosition, selectedRegion)
                }
            }
        }
    }
}