package com.yidianling.consultant.adapter

import android.content.Context
import android.graphics.Typeface
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.ydl.ydlcommon.adapter.MyBaseAdapter
import com.yidianling.consultant.R
import com.yidianling.consultant.model.bean.SubItem
import kotlinx.android.synthetic.main.consultant_item_consult_type.view.*

/**
 * 城市列表适配器
 * Created by zqk on 17-7-21.
 */
class SubRecyclerViewAdapter(val context: Context, val subList: ArrayList<SubItem>, var selectedSub: SubItem) : RecyclerView.Adapter<SubRecyclerViewAdapter.ViewHolder>() {

    var onItemClickListener: MyBaseAdapter.OnItemClickListener<SubItem>? = null

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        var region = SubItem("不限", null)
        if (position > 0) {
            region = subList[position - 1]
        }
        holder.itemView.tvConsultTypeName.text = region.value
        if (selectedSub.key == region.key) {
            //选中状态
            holder.itemView.tvConsultTypeName.setTypeface(Typeface.DEFAULT_BOLD)
            holder.itemView.tvConsultTypeName.setTextColor(ContextCompat.getColor(context,R.color.platform_main_theme))
//                holder.itemView.ivCheckCircle.visibility = View.VISIBLE
        } else {
            //未选中状态
            holder.itemView.tvConsultTypeName.setTypeface(Typeface.DEFAULT)
            holder.itemView.tvConsultTypeName.setTextColor(ContextCompat.getColor(context,R.color.platform_default_text_color))
//                holder.itemView.ivCheckCircle.visibility = View.INVISIBLE
        }
    }

    override fun getItemCount(): Int = subList.size + 1

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val view = LayoutInflater.from(context).inflate(R.layout.consultant_item_consult_type, parent, false)
        return ViewHolder(view)
    }

    inner class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        init {
            itemView.setOnClickListener {
                val position = adapterPosition
                if (position != RecyclerView.NO_POSITION) {
                    selectedSub = if (position == 0) {
                        SubItem("不限", null)
                    } else {
                        subList[adapterPosition - 1]
                    }
                    notifyDataSetChanged()
                    onItemClickListener?.onItemClickListener(itemView, adapterPosition, selectedSub)
                }
            }
        }
    }
}