package com.yidianling.consultant.contract

import android.content.Context
import com.ydl.ydlcommon.mvp.base.IModel
import com.ydl.ydlcommon.mvp.base.IPresenter
import com.ydl.ydlcommon.mvp.base.IView
import com.yidianling.consultant.bean.HotSearchBean
import io.reactivex.Observable

/**
 * @author yuanWai
 * @描述: 搜索页面约束类
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/03/19
 */
class IHotSearchContract {

    interface View : IView {
        /**
         * 搜索页接口
         */
        fun searchDataResponse(hotSearchBean: HotSearchBean)

        /**
         * 请求失败
         */
        fun requestFail()
    }

    interface Presenter : IPresenter<View> {
        /**
         * 获取本地缓存
         */
        fun localData(context: Context)

        /**
         * 搜索页接口请求
         */
        fun searchData()
    }

    interface Model : IModel {
        /**
         * 搜索页接口
         */
        fun searchData(): Observable<HotSearchBean>
    }
}