package com.yidianling.consultant.model


import com.ydl.ydlcommon.base.config.YDL_DOMAIN
import com.ydl.ydlcommon.base.config.YDL_DOMAIN_JAVA
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlnet.YDLHttpUtils
import com.yidianling.consultant.bean.ExpertSearchTopShowBean
import com.yidianling.consultant.bean.GuideBean
import com.yidianling.consultant.bean.HotSearchBean
import com.yidianling.consultant.model.bean.ExpertSearchBean
import com.yidianling.consultant.model.bean.HeadData
import io.reactivex.Observable
import retrofit2.http.*
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType


/**
 * Created by zqk on 17-10-26.
 */
interface SearchApi {

    companion object {

        var instance: SearchApi? = null

        fun getSearchApi(): SearchApi {
            if (instance == null) {
                instance = YDLHttpUtils.obtainApi(SearchApi::class.java)
            }
            return instance!!
        }
    }

    //服务列表头部
    @POST("product/list-head")
    @FormUrlEncoded
    fun listHead(@FieldMap maps: Map<String, String>): Observable<BaseResponse<HeadData>>

    //搜索条件
    @GET("consult/search/conditions")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun searchConditions(): Observable<BaseAPIResponse<HeadData>>

    //专家服务搜索
    @retrofit2.http.Headers("Content-Type:application/json")
    @GET
    fun searchDoctorService(@Url url: String): Observable<BaseAPIResponse<ExpertSearchBean>>

    //搜索页面接口
    @retrofit2.http.Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA, "Content-Type:application/json")
    @GET("home/search-page")
    fun searchPage(): Observable<BaseAPIResponse<HotSearchBean>>

    //筛选结果计数
    @retrofit2.http.Headers("Content-Type:application/json")
    @GET
    fun getFilterCount(@Url url: String?): Observable<BaseAPIResponse<Int>>

    //导医
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA, "Content-Type:application/json")
    @GET("consult/assistant/guide-switch")
    fun getConsultAssistantRequest(@Query("switchKey") switchKey: String): Observable<BaseAPIResponse<Boolean>>

    //获取咨询助理uid
    /*
    * location字段说明(sign1存储页面位置，1:首页导医入口进入2:M站入口进入3:问答列表页进入4:我的入口进入
    * 5:情绪疏导在线咨询入口进入6:咨询列表页导医入口进入7:实用心理课入口进入8:实用心理课课程列表页进入9:测评解读页进入
    * 10:搜索页面进入11:首页咨询列表进入12:厌学的真相在线咨询入口，0是小壹意向客户传0)
    *
    * ffrom_2   亲子教育添加字段
    *naviType = "1";导医配置开关，返100跳转咨询tab，如果返其他则维持原有逻辑。
    * */

    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA, "Content-Type:application/json")
    @GET("consult/assistant/chat-distribute")
    fun getConsultAssistantUidRequest(@Query("location")location: Int,@Query("ffrom_2")ffrom:String?,@Query("naviType")naviType:String="1"): Observable<BaseAPIResponse<Long>>

    //获取咨询助理uid
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA, "Content-Type:application/json")
    @POST("doctor/querySpecialTopic")
    fun getBigShotData(): Observable<BaseAPIResponse<ExpertSearchTopShowBean>>


    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    @GET("testGeneral/daoyi/setting")
    fun getGuideData(): Observable<BaseAPIResponse<Map<String, List<GuideBean>>>>

    //8-22点跳自主，其他时间跳导医，
    // 0 自主默认
    //1 自主
    //2 导医
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA, "Content-Type:application/json")
    @GET("consult/assistant/chat-time-setting")
    fun getJumpTypeRequest(): Observable<BaseAPIResponse<Int>>
}