package com.yidianling.consultant.model.bean

import android.os.Parcel
import android.os.Parcelable
import com.google.gson.annotations.SerializedName

data class CateItem(

        @field:SerializedName("cate_name")
        var cateName: String? = null,

        @field:SerializedName("cate_id")
        var cateId: Int? = null
) : Parcelable {
    constructor(source: Parcel) : this(
            source.readString(),
            source.readValue(Int::class.java.classLoader) as Int?
    )

    override fun describeContents() = 0

    override fun writeToParcel(dest: Parcel, flags: Int) = with(dest) {
        writeString(cateName)
        writeValue(cateId)
    }

    companion object {
        @JvmField
        val CREATOR: Parcelable.Creator<CateItem> = object : Parcelable.Creator<CateItem> {
            override fun createFromParcel(source: Parcel): CateItem = CateItem(source)
            override fun newArray(size: Int): Array<CateItem?> = arrayOfNulls(size)
        }
    }
}