package com.yidianling.consultant.model.bean

import com.yidianling.consultant.bean.ExpertSearchProductsBean
import com.yidianling.consultant.bean.ExpertSearchTagsIconBean

/**
 * @author yuanWai
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/12/11
 */
data class DoctorServiceItem(
    /**
     * 专家ID
     */
    val doctorId: String?,
    /**
     * 专家uid
     */
    val uid: String?,
    /**
     * 专家名称
     */
    val name: String?,
    /**
     * 跳转路由地址（正常为专家主页地址）
     */
    val linkUrl: String?,
    /**
     * 专家头像地址
     */
    val head: String?,
    /**
     * 专家是否在线 1.在线
     */
    val isOnline: Int?,
    /**
     * 能力等级 1.实习 2.新手 3.精英
     */
    val abilityLevel: Int?,
    /**
     * 有免费咨询：1.有，2.无
     */
    val hasServiceFree: Int?,
    /**
     * 活动图标
     */
    val activityImg: String?,
    /**
     * 是否参加活动
     */
    val joinActivity: Boolean?,
    /**
     * 是否新入驻：true:是，false:否
     */
    var isNewEnter: Boolean = false,
    /**
     * 好评率(倾诉+咨询)
     */
    var feedbackRate: Float = 0f,
    /**
     * 是否抗疫先锋图标
     */
    var fightEpidemicIconShow: Boolean = false,
    /**
     * 评价数(咨询订单数)
     */
    var zixunOrderNum: Int = 0,
    /**
     * 咨询最低价
     */
    val minBookingPrice: String?,
    /**
     * 资质材料
     */
    val teamCertifications: String?,
    /**
     * 标签分类
     */
    val tags: String?,
    /**
     * 已帮助人数(咨询人数)
     */
    val zixunOrderUser: String?,
    /**
     * 月售时长
     */
    var saleDurationForMonth: Float = 0f,
    /**
     * 服务时长
     */
    var allSaleDuration: Float = 0f,
    /**
     * 服务
     */
    val products: MutableList<ExpertSearchProductsBean>?,
    /**
     * 标签图片
     */
    val tagsIcon: ExpertSearchTagsIconBean?,
    /**
     * 今日是否可约
     */
    val isTodayFree: Boolean?,
    /**
     * 是否咨询中
     */
    var inConsult: Boolean = false,
    /**
     * 是否聆听中
     */
    var isListening: Boolean = false,
    /**
     * 私聊人数
     */
    var chatNum: Int = 0,
    /**
     * 个人铭言
     */
    val famousRemark: String?,
    /**
     * 省
     */
    val province: String?,
    /**
     * 市
     */
    val city: String?,
    /**
     * 私聊按钮的文案(如果不为空则取这个字段的值，如果为空 则默认为：“私聊”)
     */
    val chatBtnText: String?
)