package com.yidianling.course;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import androidx.constraintlayout.widget.ConstraintLayout;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.ydl.ydl_router.manager.YDLRouterManager;
import com.yidianling.course.bean.Course;
import com.yidianling.course.coursePlay.CourseCommentActivity;
import com.yidianling.course.widget.CourseItemNewView;


/**
 * Created by zqk on 6/22/17.
 */

public class CourseListItemView extends ConstraintLayout implements View.OnClickListener {

    CourseItemNewView courseItemNewView;

    LinearLayout ivExportBtnLayout;
    View tvLineBottom;
    TextView tvCourseItemFirst;
    TextView tvCourseItemComment;

    private Course mCourse;
    private Context context;

    public CourseListItemView(Context context) {
        super(context);
        this.context = context;
        View view = inflate(context, R.layout.item_course_list, this);

        courseItemNewView = view.findViewById(R.id.view_content);
        ivExportBtnLayout = view.findViewById(R.id.iv_export_btn_layout);
        tvLineBottom = view.findViewById(R.id.tv_line_bottom);
        tvCourseItemFirst = view.findViewById(R.id.tv_course_item_first);
        tvCourseItemComment = view.findViewById(R.id.tv_course_item_comment);
    }

    @SuppressLint("SetTextI18n")
    public void setData(Course course) {
        mCourse = course;

        courseItemNewView.setData(course);
        courseItemNewView.hideListenerButton();

        //显示item下面的私聊，倾诉，咨询入口
        if (course.isShowHostButton == 1) {
            ivExportBtnLayout.setVisibility(View.VISIBLE);
            tvLineBottom.setVisibility(View.VISIBLE);

            if (course.userCommentNum == 0) {
                tvCourseItemComment.setVisibility(VISIBLE);
            } else {
                tvCourseItemComment.setVisibility(GONE);
            }
            if (course.isOpenChat == 1) {
                tvCourseItemFirst.setVisibility(VISIBLE);
            } else {
                tvCourseItemFirst.setVisibility(GONE);
            }

            if (course.userCommentNum != 0 && course.isOpenChat != 1) {
                ivExportBtnLayout.setVisibility(View.GONE);
                courseItemNewView.setBottomLineGone();
            } else {
                ivExportBtnLayout.setVisibility(View.VISIBLE);
                courseItemNewView.setBottomLineVisible();
            }
        } else {
            ivExportBtnLayout.setVisibility(View.GONE);
            courseItemNewView.setBottomLineGone();
        }

        tvCourseItemComment.setOnClickListener(v -> CourseCommentActivity.Companion.startActivity((Activity) context, mCourse.id + ""));
        tvCourseItemFirst.setOnClickListener(v -> YDLRouterManager.Companion.router(mCourse.chatLinkUri));
    }

    @Override
    public void onClick(View v) {
    }
}
