package com.yidianling.course.courseNew

import android.content.Context
import androidx.collection.SparseArrayCompat
import androidx.recyclerview.widget.RecyclerView
import android.view.View
import android.view.ViewGroup
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydlcommon.view.BaseViewHolder
import com.yidianling.course.CourseConstants
import com.yidianling.course.bean.Course
import com.yidianling.course.widget.CourseItemNewView

/**
 * Created by Jim on 2018/7/12 0012.
 */
class CourseTopicAdapter(val context: Context, var mDatas: List<Course>) : RecyclerView.Adapter<BaseViewHolder>() {

    private val BASE_ITEM_TYPE_HEADER = 100000
    private val BASE_ITEM_TYPE_FOOTER = 200000


    private var mHeaderViews: SparseArrayCompat<View> =
        SparseArrayCompat()
    private var mFootViews: SparseArrayCompat<View> =
        SparseArrayCompat()


    fun addHeaderView(v: View?) {
        mHeaderViews.put(mHeaderViews.size() + BASE_ITEM_TYPE_HEADER, v)
    }

    fun addFooterView(v: View?) {
        mFootViews.put(mFootViews.size() + BASE_ITEM_TYPE_FOOTER, v)
    }

    fun getHeadersCount(): Int = mHeaderViews.size()

    fun getFootersCount(): Int = mFootViews.size()

    private fun isHeaderView(position: Int): Boolean {
        return position < getHeadersCount()
    }

    private fun isFooterView(position: Int): Boolean {
        return position >= getHeadersCount() + mDatas.size
    }

    fun setDatas(datas: List<Course>?) {
        if (datas != null) {
            mDatas = datas
        }
    }


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): BaseViewHolder {
        if (mHeaderViews.get(viewType) != null) {
            return BaseViewHolder(mHeaderViews.get(viewType), context, viewType)
        }
        if (mFootViews.get(viewType) != null) {
            return BaseViewHolder(mFootViews.get(viewType), context, viewType)
        }
        val view = CourseItemNewView(context)
        return BaseViewHolder(view, context, viewType)
    }

    override fun onBindViewHolder(holder: BaseViewHolder, position: Int) {
        if (isHeaderView(position)) {
            return
        }
        if (isFooterView(position)) {
            return
        } else {
            val course = mDatas[position - getHeadersCount()]
            (holder.getItemView() as CourseItemNewView).setData(course)
            if (position == itemCount - getFootersCount() - 1) {
                (holder.getItemView() as CourseItemNewView).setBottomLineGone()
            }
            holder.itemView.setOnClickListener { view ->
                NewH5Activity.start(context, H5Params(CourseConstants.COURSE_DETAIL_H5 + course.id, null))
            }
        }

    }

    override fun getItemViewType(position: Int): Int {
        if (isHeaderView(position)) {
            return mHeaderViews.keyAt(position)
        } else if (isFooterView(position)) {
            return mFootViews.keyAt(position - mDatas.size - getHeadersCount())
        }
        return super.getItemViewType(position)
    }

    override fun getItemCount(): Int {
        if (mDatas != null && mDatas!!.size > 0) {
            return mDatas!!.size + getHeadersCount() + getFootersCount()
        }
        return getFootersCount() + getHeadersCount()
    }

}