package com.yidianling.course.coursePlay

import android.annotation.SuppressLint
import android.text.TextUtils
import android.view.View
import android.widget.LinearLayout
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydl_image.module.GlideApp
import com.yidianling.common.tools.ToastUtil
import com.yidianling.course.CourseConstants
import com.yidianling.course.R
import com.yidianling.course.bean.CourseExtraBean
import kotlinx.android.synthetic.main.item_course_play_head.view.*

/**
 * 课程播放页面--recyclerView头view
 * Created by harvie on 2017/6/26 0026.
 */
class CourseHeadView : LinearLayout {
    //课程id
    var courseId = ""

    var activity: CoursePlayActivity? = null

    constructor(context: CoursePlayActivity) : super(context) {
        this.activity = context
        View.inflate(context, R.layout.item_course_play_head, this)
        initView()
    }

    fun initView() {
        setCourseInfoClick()
    }

    //设置课程详情点击事件
    private fun setCourseInfoClick() {
        setOnClickListener {
            if (TextUtils.isEmpty(courseId)) {
                ToastUtil.toastShort("课程id错误")
            } else {
                activity!!.showVideoFloatView()
                //跳转课程H5详情
                NewH5Activity.start(activity, H5Params(CourseConstants.COURSE_DETAIL_H5 + courseId, null))
            }
        }
    }

    //设置数据
    @SuppressLint("SetTextI18n")
    fun setData(bean: CourseExtraBean) {
        courseId = bean.id
        GlideApp.with(context).load(bean.doctorHead).error(R.drawable.course_head_place_hold_pic).into(img_head)
        if (TextUtils.isEmpty(bean.doctorName)) {
            ll_info.visibility= View.GONE
        }else{
            ll_info.visibility= View.VISIBLE
        }
        text_user_name.text = bean.doctorName
        text_user_des.text = bean.title

        val types = when {
            bean.mediaTypes == 1 -> "音频"
            bean.mediaTypes == 2 -> "视频"
            else -> "音频 视频"
        }
        tv_media_num.text = bean.serialsNumber.toString() + "节系列课 | $types"
    }
}