package com.yidianling.course.link

import android.content.Context
import android.content.Intent
import android.net.Uri
import android.text.TextUtils
import com.yidianling.course.courseNew.CourseTopicActivity
import com.yidianling.course.course_special_list.activity.CourseSpecialListActivity

/**
 * @author yuanwai
 * @描述:路由
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/19
 */
class CourseLinkUrl{
    companion object {
        fun jump(context: Context,url : String?){
            if (TextUtils.isEmpty(url)){
                return
            }
            var uri = Uri.parse(url)
            if (null == uri){
                return
            }
            newLink(context,uri)
        }
        //新版本路由协议 ydl-user://xxx/xxx/?id=3
        private fun newLink(context: Context, uri: Uri){
            when(uri.host){
                "course" ->{
                    //课程
                    if ("/special" == uri.path){
                        //专题页
                        var id = uri.getQueryParameter("id")
                        if (TextUtils.isEmpty(id)){
                            return
                        }
                        //跳转课程专题页面
                        CourseTopicActivity.start(context,id)
                    }else if("/speciallist" == uri.path){
                        //跳转专题列表页
                        context.startActivity(Intent(context, CourseSpecialListActivity::class.java))
                    }
                }
            }
        }
    }
}