package com.yidianling.course.modular_service

import android.app.Activity
import android.app.Application
import android.content.Context
import android.content.Intent
import com.alibaba.android.arouter.facade.annotation.Route
import com.ydl.media.audio.AudioPlayer
import com.ydl.media.view.PlayerFloatHelper
import com.ydl.course.api.ICourseService
import com.yidianling.course.courseNew.CourseTopicActivity
import com.yidianling.course.courseNew.mine.MyCourseActivity
import com.yidianling.course.coursePlay.CourseCommentActivity
import com.yidianling.course.coursePlay.CoursePlayActivity
import com.yidianling.course.coursePlay.CourseReplyListActivity
import com.yidianling.course.flutterPlugin.CourseSendPlugin
import com.yidianling.course.lifeCallback.CoursePlayLifecycle
import java.util.*

/**
 * @author jiucheng
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/11/12
 */
@Route(path = "/course/CourseService")
class CourseServiceImp : ICourseService {
    override fun courseTopic(activity: Activity, id: String) {
        CourseTopicActivity.start(activity, id)
    }

    override fun closePlayer() {
        if (AudioPlayer.get().isPlaying){
            AudioPlayer.get().stopPlayer()
        }
    }

    override fun isPlaying(): Boolean {
        return AudioPlayer.get().isPlaying
    }

    override fun startCoursePlayPage(activity: Activity, from: Int) {
        PlayerFloatHelper.startCoursePlayActivity(activity,from)
    }

    override fun play() {
        AudioPlayer.get().play()
    }

    override fun pause() {
        AudioPlayer.get().playPause()
    }

    override fun sendLoginStatusToFlutter() {
        CourseSendPlugin.sendLoginSuccess()
    }

    override fun startMyCourseActivity(context: Context) {
        MyCourseActivity.start(context)
    }

    override fun startCoursePlayActivity(activity: Activity, courseId: Int, coursePlayUrl: String?, from: Int, mediaType: String?) {
        val intent = Intent(activity, CoursePlayActivity::class.java)
        intent.putExtra("course_id", courseId)
        intent.putExtra("coursePlayUrl", coursePlayUrl)
        intent.putExtra("from", from)
        intent.putExtra("mediaType", mediaType)
        activity.startActivity(intent)
    }

    override fun startCourseCommentActivity(activity: Activity, courseId: String) {
        CourseCommentActivity.startActivity(activity, courseId)
    }

    override fun startCourseReplyActivity(activity: Activity, courseId: String) {
        val intent = Intent(activity, CourseReplyListActivity::class.java)
        intent.putExtra("course_id", courseId)
        activity.startActivity(intent)
    }

    override fun initCoursePlayLifeCircle(application: Application) {
        application.registerActivityLifecycleCallbacks(CoursePlayLifecycle())
    }

    override fun init(context: Context?) {
    }
}