package com.yidianling.course.net;

import com.ydl.ydlcommon.data.http.BaseCommand;
import com.ydl.ydlcommon.router.YdlCommonOut;

/**
 * Created by Jim on 2018/2/26 0026.
 */

public class Command {
    //获取课程播放页 初始化数据
    public static class GetCoursePlayData extends BaseCommand {
        public int course_id;
        public int type;


        public GetCoursePlayData(int course_id, int type) {
            this.course_id = course_id;
            this.type = type;
        }

    }

    //参加课程
    public static class CourseAddOrder extends BaseCommand {
        public int course_id;
        public String from;

        public CourseAddOrder(int course_id) {
            this.course_id = course_id;
            this.from = YdlCommonOut.Companion.getChannelName();
        }

    }

    //课程提交回复
    public static class CourseCommitReply extends BaseCommand {
        public int courseId;
        public String content;//评论内容

        public CourseCommitReply(int course_id, String content) {
            this.courseId = course_id;
            this.content = content;
        }

    }

    //课程播放页--点赞
    public static class CoursePlayZan extends BaseCommand {

        public int course_id;

        public CoursePlayZan(int course_id) {
            this.course_id = course_id;
        }

    }

    //课程课后笔记列表
    public static class CourseReplyList extends BaseCommand {
        public int course_id;
        public int page;


        public CourseReplyList(int course_id, int page) {
            this.page = page;
            this.course_id = course_id;
        }

    }

    //获取课程列表
    public static class GetCourse extends BaseCommand {
        public int page;
        public int type;
        public int child_type;

        public GetCourse(int page, int type) {
            this.page = page;
            this.type = type;
        }

        public GetCourse(int page, int type, int child_type) {
            this.page = page;
            this.type = type;
            this.child_type = child_type;
        }
    }

    //获取课程专题
    public static class CourseSpecial extends BaseCommand {

        public int special_id;

        public CourseSpecial(int special_id) {
            this.special_id = special_id;
        }

    }

}
