package com.yidianling.course.widget

import android.app.Activity
import android.app.Dialog
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.text.TextUtils
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.yidianling.common.tools.RxImageTool
import com.yidianling.course.R
import com.yidianling.course.bean.CourseCouponBean
import kotlinx.android.synthetic.main.dialog_course_coupon.*

/**
 * @author jiucheng
 * @描述:课程优惠券
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/3/25
 */
class CourseCouponDialog(private var activity: Activity?, var list: List<CourseCouponBean>, var listener: OnClickEnsureListener?) : Dialog(activity) {
    var status: Int = STATUS_RECEIVER
    private var courseCouponBean: CourseCouponBean? = null
    //领取成功的张数
    private var successCount = 0

    companion object {
        var STATUS_RECEIVER = 0 //立即领取
        var STATUS_GET = 1 //查看我的卡券
    }

    init {
        this.courseCouponBean = list[0]
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.dialog_course_coupon)
        setCanceledOnTouchOutside(false)

        setCardViewHeight()

        initCouponView(list, false)

        iv_close.setOnClickListener {
            dismiss()
        }

        tv_ensure.setOnClickListener {
            if (listener != null) {
                if (status == STATUS_GET && successCount == 0) {
                    dismiss()
                } else {
                    listener!!.clickEnsure(status)
                }

            }
        }
        window.setBackgroundDrawable(ColorDrawable())

        updateUiByStatus()
    }

    private fun setCardViewHeight() {
        if (list.size < 2) {
            var parms = LinearLayout.LayoutParams(RxImageTool.dp2px(310f), RxImageTool.dp2px(300f))
            parms.leftMargin = RxImageTool.dp2px(32f)
            parms.rightMargin = RxImageTool.dp2px(32f)
            card_view.layoutParams = parms
        }
    }

    private fun updateDetailView() {
        repeat(ll_content.childCount) {
            var view = ll_content.getChildAt(it)
            if (view is CourseCouponDetailView) {
                view.setUseVisibility(true)
            }
        }
    }

    /**
     * [status] 状态码
     * [ids] 领取成功的优惠券id
     */
    fun updateStatus(status: Int, ids: List<String>?) {
        this.status = status
        //对比领取成功的id和所有优惠券的id
        if (this.status == STATUS_GET) {
            if (ids == null || ids.isEmpty()) {
                successCount = 0
                ll_content.removeAllViews()
            } else {
                successCount = ids.size
                compareOriginalWithSuccess(ids)
            }
        }
        updateUiByStatus()
    }

    private fun updateUiByStatus() {
        var title = ""
        var ensureText = ""
        when (status) {
            STATUS_RECEIVER -> {
                title = "有${list.size}张课程优惠券可领取"
                ensureText = "立即领取"
            }
            STATUS_GET -> {
                if (successCount == 0) {
                    title = "优惠券已经被领光啦"
                    ensureText = "看看课程吧"
                    iv_empty.visibility = View.VISIBLE
                    scrollview.visibility = View.GONE
                } else {
                    title = if (successCount == list.size) {
                        "领取成功"
                    } else {
                        "您成功领取${successCount}张优惠券"
                    }
                    if (successCount != list.size) {
                        tv_introduction.visibility = View.VISIBLE
                    }
                    ensureText = "查看我的卡券"
                    updateDetailView()
                }
            }
        }
        tv_title.text = title
        tv_ensure.text = ensureText
    }


    private fun initCouponView(list: List<CourseCouponBean>?, hasReceived: Boolean) {
        ll_content.removeAllViews()
        if (list!!.size == 1) {
            var params = LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
            params.topMargin = RxImageTool.dp2px(26f)
            scrollview.layoutParams = params
        }
        repeat(list!!.size) { it ->
            val couponDetailView = CourseCouponDetailView(activity!!)
            couponDetailView.setData(list[it], hasReceived) {
                if (listener != null) {
                    listener!!.clickUse(it)
                }
            }
            ll_content.addView(couponDetailView)
        }
    }

    private fun compareOriginalWithSuccess(ids: List<String>) {
        if (ids.size == list!!.size) {
            return
        }
        val resultList = ArrayList<CourseCouponBean>()
        repeat(ids.size) {
            val id = ids[it]
            for (bean in list!!) {
                if (TextUtils.equals(id, bean.id)) {
                    resultList.add(bean)
                }
            }
        }
        initCouponView(resultList, true)
    }

    interface OnClickEnsureListener {
        fun clickEnsure(status: Int)

        fun clickUse(toLink: String)
    }

    override fun show() {
        if (null == activity || activity!!.isFinishing) {
            return
        }
        super.show()
    }
}