package com.yidianling.dynamic.activity

import android.os.Bundle
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentPagerAdapter
import androidx.viewpager.widget.ViewPager
import butterknife.ButterKnife
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.bean.StatusBarOptions
import com.yidianling.dynamic.R
import com.yidianling.dynamic.router.DynamicIn
import com.yidianling.dynamic.trendList.TrendsListFragment
import kotlinx.android.synthetic.main.dynamic_activity_mytrends.*
import java.util.*


/**
 * 我的动态
 * Created by hgw on 2017/3/29.
 */

class MyTrendsActivity : BaseActivity() {

    internal var select_tab: Int = 0//当前动态列表的标示
    internal var tab = "3"

    internal var page = 1


    private var sendFragment: TrendsListFragment? = null
    private var replyFragment: TrendsListFragment? = null//我发布的和我回复的
    private var pagerAdapter: FragmentPagerAdapter? = null

    private val fragmentList = ArrayList<TrendsListFragment>()


    override fun getStatusViewOptions(): StatusBarOptions {
        return StatusBarOptions(isAddStatusView = true, statusBarDarkMode = true)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.dynamic_activity_mytrends)
        ButterKnife.bind(this)

        sendFragment = TrendsListFragment.newInstance(
            1,
            0,
            TrendsListFragment.TREND_TYPE_MY_TREND,
            DynamicIn.getUserInfo()!!.uid + ""
        )
        replyFragment = TrendsListFragment.newInstance(
            2,
            0,
            TrendsListFragment.TREND_TYPE_MY_TREND,
            DynamicIn.getUserInfo()!!.uid + ""
        )
        fragmentList.add(sendFragment!!)
        fragmentList.add(replyFragment!!)

        initV()
        initClick()
    }

    private fun initV() {
        pagerAdapter = object : FragmentPagerAdapter(supportFragmentManager) {
            override fun getItem(position: Int): Fragment {
                return fragmentList[position]
            }

            override fun getCount(): Int {
                return fragmentList.size
            }
        }
        viewpager_frag!!.adapter = pagerAdapter

        viewpager_frag!!.addOnPageChangeListener(object : ViewPager.OnPageChangeListener {
            override fun onPageScrolled(
                position: Int,
                positionOffset: Float,
                positionOffsetPixels: Int
            ) {

            }

            override fun onPageSelected(position: Int) {
                changeLabel(position, false)
            }

            override fun onPageScrollStateChanged(state: Int) {

            }
        })
    }

    private fun initClick() {
        image_back.setOnClickListener {
            finish()
        }
        item_topic_detail_new_tv.setOnClickListener {
            //我发布的
            changeLabel(0, true)
        }
        item_topic_detail_hot_tv.setOnClickListener {
            //我评论的
            changeLabel(1, true)
        }
    }

    //切换标签选中状态
    private fun changeLabel(position: Int, isChangeFragment: Boolean) {
        if (position == 0) {
            item_topic_detail_new_tv!!.setTextColor(resources.getColor(R.color.platform_main_theme))

            item_topic_detail_new_hint_tv!!.setBackgroundColor(resources.getColor(R.color.platform_main_theme))

            item_topic_detail_hot_tv!!.setTextColor(resources.getColor(R.color.dynamic_text_gray))
            item_topic_detail_hot_hint_tv!!.setBackgroundColor(resources.getColor(R.color.dynamic_white))

        } else if (position == 1) {
            item_topic_detail_new_tv!!.setTextColor(resources.getColor(R.color.dynamic_text_gray))

            item_topic_detail_new_hint_tv!!.setBackgroundColor(resources.getColor(R.color.dynamic_white))

            item_topic_detail_hot_tv!!.setTextColor(resources.getColor(R.color.platform_main_theme))
            item_topic_detail_hot_hint_tv!!.setBackgroundColor(resources.getColor(R.color.platform_main_theme))
        }

        if (isChangeFragment) {
            viewpager_frag!!.currentItem = position
        }

    }

    override fun layoutResId(): Int {
        return 0
    }

    override fun initDataAndEvent() {

    }
}
