package com.yidianling.dynamic.model;

import com.ydl.ydlcommon.base.config.HttpConfig;
import com.ydl.ydlcommon.data.http.BaseCommand;
import com.ydl.ydlcommon.router.YdlCommonOut;

/**
 * Created by Jim on 2018/2/5 0005.
 */

public class Command {
    //点赞：动态，回帖，个人主页
    public static class ZanAction extends BaseCommand {
        public String type;//业务类型：1访问用户，2动态，3话题
        public String id;//动态id,回复id,用户uid

        public ZanAction(String type, String id) {
            this.type = type;
            this.id = id;
        }

    }


    //获取社区帖子评论详情
    public static class TrendsReplyInfo extends BaseCommand {

        public String id;//评论id
        public String aid;//标识当前是否为点赞详情

        public TrendsReplyInfo(String id, String aid) {
            super();
            this.id = id;
            this.aid = aid;
        }

    }

    public static class UserAndTrendVisitCmd extends BaseCommand {
        public String type;
        public String id;

        public UserAndTrendVisitCmd(String type, String id) {
            this.type = type;
            this.id = id;
        }

    }


    // 个人资料
    public static class MemberInfoCmd extends BaseCommand {
        public String id;


        public MemberInfoCmd(String id) {
            this.id = id;

        }

    }

    public static class RmBlack extends BaseCommand {
        public String uidBlack;

        public RmBlack(String uidBlack) {
            this.uidBlack = uidBlack;
        }

        public String getUrl() {
            return "" + "/consult/rm-black";
        }
    }

    //关注
    public static class FocusCmd extends BaseCommand {
        public String id;//话题id或用户uid
        public String type;//业务类型：1关注用户，2关注话题

        public FocusCmd(String id, String type) {
            this.id = id;
            this.type = type;
        }

    }

    //加入黑名单
    public static class SetBlackCall extends BaseCommand {
        public String uidBlack;

        public SetBlackCall(String uidBlack) {
            super();
            this.uidBlack = uidBlack;
        }

    }


    //获取举报理由
    public static class GetReportReason extends BaseCommand {

    }


    //举报心事或者心事回复(动态)
    public static class ReportWorry extends BaseCommand {

        public int id;//心事id
        public int reasonId;//举报理由的id
        public int answerId;//如果是针对心事的举报，需要指定该值为0
        public String answerContent;//如果是针对心事的举报，指定该值为空即可
        public int type;//1举报心事(帖子和评论回复)，2个人

        //for worry
        public ReportWorry(int id, int reasonId) {
            this(id, reasonId, 0, null, 1);
        }

        // for worry's reply
        public ReportWorry(int id, int reasonId, int answerId, String answerContent, int type) {
            this.id = id;
            this.reasonId = reasonId;
            this.answerId = answerId;
            this.answerContent = answerContent;
            this.type = type;
        }


    }


    //发布动态
    public static class PublishTrend extends BaseCommand {
        public int anonymous;//是否匿名：1否，2匿名
        public int is_doctor_show = 2;// 1仅专家可见 2所有可见
        public String ext_type;//5动态 6问答
        public String topic_id;//话题id
        public String content;//内容
        public String title;//话题
        public String ext_title;//扩展标题
        public String ext_cover;//扩展图片
        public String ext_url;//扩展url

        public PublishTrend(int anonymous, String topic_id, String content, String title, String ext_type, int is_doctor_show) {
            this.anonymous = anonymous;
            this.is_doctor_show = is_doctor_show;
            this.ext_type = ext_type;
            this.topic_id = topic_id;
            this.content = content;
            this.title = title;
        }

        public PublishTrend(int anonymous, String topic_id, String content, String title, String ext_title, String ext_cover, String ext_url, String ext_type, int is_doctor_show) {
            this.anonymous = anonymous;
            this.topic_id = topic_id;
            this.content = content;
            this.is_doctor_show = is_doctor_show;
            this.title = title;
            this.ext_title = ext_title;
            this.ext_cover = ext_cover;
            this.ext_type = ext_type;
            this.ext_url = ext_url;
        }

    }

    //话题列表
    public static class AllTopicCmd extends BaseCommand {
        public String cate;
        public String my;

        public AllTopicCmd(String cate, String my) {
            this.cate = cate;
            this.my = my;

        }

    }

    //话题详情
    public static class TopicDetailCmd extends BaseCommand {
        public String id;


        public TopicDetailCmd(String id) {
            this.id = id;

        }

    }

    public static class AdClickCount extends BaseCommand {
        public int foc_id;

        public AdClickCount(int foc_id) {
            this.foc_id = foc_id;
        }
    }

    //动态列表
    public static class TrendListCmd extends BaseCommand {
        public String tab;
        public int page;
        public String topicId;//默认0,话题id:用于获取话题详情的动态
        public String id;//列表最后一条帖子的id（用于后台定位）
        public int dyEntrance;
        public TrendListCmd(String tab, int page, String topic_id, String last_id) {
            this.tab = tab;
            this.page = page;
            this.topicId = topic_id;
            this.id = last_id;
        }
    }

    //个人动态
    public static class UserTrendCmd extends BaseCommand {
        public String id;
        public int page;
        public int tab = 1;


        public UserTrendCmd(String id, int page) {
            this.id = id;
            this.page = page;
        }

        public UserTrendCmd(String id, int tab, int page) {
            this.id = id;
            this.page = page;
            this.tab = tab;
        }

    }

    public static class FetchTestDetailCommand extends BaseCommand {
        String id;

        public FetchTestDetailCommand(String id) {
            this.id = id;
        }
    }

    //获取社区帖子评论列表
    public static class TrendsComments extends BaseCommand {

        public String id;//动态id
        //        public String page;//页码,大于等于2
        public String first_page;//1表示从动态列表过来，0表示其他

        public String last_aid;//列表最后一个评论的id
        public String direction;//1上加载，0下加载

        public TrendsComments(String id, String first_page, String last_aid, String direction) {
            super();
            this.id = id;
//            this.page = page;
            this.first_page = first_page;
            this.last_aid = last_aid;
            this.direction = direction;
        }

    }


    //帖子或评论删除
    public static class TrendsReplyDel extends BaseCommand {

        public int type;// 移除类型：1移除评论，2移除动态
        public int id;//评论的id,动态id

        public TrendsReplyDel(int type, int id) {
            super();
            this.type = type;
            this.id = id;
        }
    }


    //私聊 获取聊天者的订单关系数据
    public static class GetExpert extends BaseCommand {

        public String toUid;
        public int canTalk;//为3的时候扣分

        public GetExpert(String toUid, int canTalk) {
            this.toUid = toUid;
            this.canTalk = canTalk;
        }

    }

    //回复盖楼
    public static class CommentOrReply extends BaseCommand {
        public String type;//业务类型：1回复动态，2盖楼
        public String id;//动态id，楼层id
        public String content;//内容

        public CommentOrReply(String type, String id, String content) {
            this.type = type;
            this.id = id;
            this.content = content;
        }

    }

    //获取社区帖子详情
    public static class TrendsInfo extends BaseCommand {

        public int askId;

        public TrendsInfo(int askId) {
            super();
            this.askId = askId;
        }
    }

    //感谢表单提交
    public static class SubmitZan extends BaseCommand {

        public int recieveUid;
        public int starNum;
        public String content;
        public int answerId;
        public int type;//类型，值为1或者2，默认为1。1带有心形数量的感谢；2只留个言，心形数量为0

        public SubmitZan(int recieveUid, int starNum, String content, int answerId, int type) {
            this.recieveUid = recieveUid;
            this.starNum = starNum;
            this.content = content;
            this.answerId = answerId;
            this.type = type;
        }
    }


    // 送感谢 (为了获取相关数据)
    public static class GetThxHeadDate extends BaseCommand {

        public int answerId;

        public GetThxHeadDate(int answerId) {
            this.answerId = answerId;
        }

    }

    //获取赞列表
    public static class GetZanList extends BaseCommand {

        public int page;
        public int answerId;

        public GetZanList(int page, int answerId) {
            super();
            this.page = page;
            this.answerId = answerId;
        }
    }

    //获取专家相关信息
    public static class Service extends BaseCommand {
        public String id;

        public Service(String id) {
            this.id = id;
        }

    }

    public static class ConnectListen extends BaseCommand {

        public int id;

        public ConnectListen(int id) {
            this.id = id;
        }

        public String getUrl() {
            return HttpConfig.Companion.getPHP_BASE_URL()+ "/listen/connect";
        }
    }

}
