package com.yidianling.dynamic.model;


import com.google.gson.annotations.SerializedName;
import com.ydl.ydlcommon.bean.ShareData;

/**
 * 评论Bean
 * Created by hgw on 2017/3/20.
 */

public class CommentBean {

    private int id;//评论id
    private String uid;//
    private String name;
    private String content;//评论内容
    @SerializedName(value = "header",alternate = "userHead")
    private String header;//头像
    private int to_id;//原发布人评论id
    private int to_uid;//被引用人uid

    @SerializedName(value = "doctor_id",alternate = "doctorId")
    private int doctor_id;
    @SerializedName(value = "to_name",alternate = "toName")
    private String to_name;//原话发布人
    @SerializedName(value = "to_content",alternate = "toContent")
    private String to_content;//引用的原话
    private String time_str;
    private int gender;//1男2女
    @SerializedName(value = "user_type",alternate = "userType")
    private int user_type;//1用户2专家3助理
    @SerializedName(value = "is_zan",alternate = "isZan")
    private int is_zan;//1赞2未赞
    private ShareData share_data;
    private int isAvailable; //是否空闲 0-否 1-是
    private int isOpenListen; //是否开通倾诉 0-否 1-是

    private String listenLinkUrl; //统一路由url

    public String getListenLinkUrl() {
        return listenLinkUrl;
    }

    public void setListenLinkUrl(String listenLinkUrl) {
        this.listenLinkUrl = listenLinkUrl;
    }

    public int getIsAvailable() { return isAvailable; }

    public int getIsOpenListen() {
        return isOpenListen;
    }

    public ShareData getShare_data() {
        return share_data;
    }

    public void setShare_data(ShareData share_data) {
        this.share_data = share_data;
    }

    public CommentBean() {
    }

    public CommentBean(int id, String uid, String name, String content, String header, int to_id, int to_uid, int doctor_id, String to_name, String to_content, String time_str, int gender, int user_type, int is_zan) {
        this.id = id;
        this.uid = uid;
        this.name = name;
        this.content = content;
        this.header = header;
        this.to_id = to_id;
        this.to_uid = to_uid;
        this.doctor_id = doctor_id;
        this.to_name = to_name;
        this.to_content = to_content;
        this.time_str = time_str;
        this.gender = gender;
        this.user_type = user_type;
        this.is_zan = is_zan;
    }
    public int getDoctor_id() {
        return doctor_id;
    }

    public void setDoctor_id(int doctor_id) {
        this.doctor_id = doctor_id;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public int getTo_uid() {
        return to_uid;
    }

    public void setTo_uid(int to_uid) {
        this.to_uid = to_uid;
    }

    public int getTo_id() {
        return to_id;
    }

    public void setTo_id(int to_id) {
        this.to_id = to_id;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getHeader() {
        return header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getTo_name() {
        return to_name;
    }

    public void setTo_name(String to_name) {
        this.to_name = to_name;
    }

    public String getTo_content() {
        return to_content;
    }

    public void setTo_content(String to_content) {
        this.to_content = to_content;
    }

    public String getTime_str() {
        return time_str;
    }

    public void setTime_str(String time_str) {
        this.time_str = time_str;
    }

    public int getGender() {
        return gender;
    }

    public void setGender(int gender) {
        this.gender = gender;
    }

    public int getUser_type() {
        return user_type;
    }

    public void setUser_type(int user_type) {
        this.user_type = user_type;
    }

    public int getIs_zan() {
        return is_zan;
    }

    public void setIs_zan(int is_zan) {
        this.is_zan = is_zan;
    }
}
