package com.yidianling.dynamic.model;

import java.util.ArrayList;
import java.util.List;

/**
 * 动态详情Bean
 * Created by hgw on 2017/3/21.
 */

public class TrendsInfoBean {

    public TrendBody active;//帖子内容

    public List<ZanImg> members;//点赞用户列表

    public List<CommentBean> comments;//评论列表

    //帖子详情
    public static class TrendBody {

        public int id;//帖子id
        public int is_self;//是否是自己的帖子1是0不是
        public String name;
        public String header;//头像
        public int gender;//1男2女
        public int is_top;//1普通2置顶
        public String title;//帖子标题
        public String time_str;//时间
        public String from;//来自设备
        public String visit_count;//访问量
        public int is_zan;//是否已赞 1已赞2未赞
        public int zan_count;
        public int reply_count;//回复数
        public String content;//正文
        public ArrayList<IMage> big_attach;//大图
        public int topic_id;//话题id
        public String topic_title;//话题标题
        public String is_focused;//1已关注，2未关注
        public int uid = 0;
        public String multitext_type;//动态类型
        public ExtAd ext;
    }

    //图片
    public static class IMage{
        public String url;
        public int width;
        public int height;
    }

    //赞列表Bean
    public static class ZanImg {
        public String head;//赞头像
        public int uid;//赞用户id

        public ZanImg() {
        }

        public ZanImg(String head, int uid) {
            this.head = head;
            this.uid = uid;
        }
    }

    /**
     * 广告
     */
    public static class ExtAd {
        public String title;
        public String url;
        public String cover;
    }

}
