package com.yidianling.dynamic.thank.view;

import android.content.Context;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.ydl.ydl_image.module.GlideApp;
import com.ydl.ydl_image.transform.GlideCircleTransform;
import com.yidianling.dynamic.R;
import com.yidianling.dynamic.R2;
import com.yidianling.dynamic.thank.data.ThxZan;

import butterknife.BindView;
import butterknife.ButterKnife;

/**
 * 感谢回复
 * Created by softrice on 15/12/3.
 */
public class ZanReplyListItemView extends LinearLayout {

    @BindView(R2.id.sdv_head)
    ImageView sdv_head;
    @BindView(R2.id.tv_zan_num)
    TextView tv_zan_num;
    @BindView(R2.id.tv_name)
    TextView tv_name;
    @BindView(R2.id.tv_time)
    TextView tv_time;
    @BindView(R2.id.tv_content)
    TextView tv_content;


    public ZanReplyListItemView(Context context) {
        super(context);
        inflate(context,R.layout.dynamic_ui_zan_reply_list,this);
        ButterKnife.bind(this);

    }


    public void setData(ThxZan thxZan) {
        GlideApp.with(getContext())
                .load(thxZan.head)
                .transform(new GlideCircleTransform(getContext()))
                .placeholder(R.drawable.dynamic_head_place_hold_pic)
                .error(R.drawable.dynamic_head_place_hold_pic)
                .into(sdv_head);
        if (thxZan.num.endsWith("0"))
            tv_zan_num.setText("");
        else
            tv_zan_num.setText(thxZan.num);
        tv_name.setText(thxZan.name);
        tv_time.setText(thxZan.time);
        tv_content.setText(thxZan.content);
    }


}
