package com.yidianling.dynamic.trendList.adapter;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.yidianling.common.tools.LogUtil;
import com.yidianling.dynamic.R;
import com.yidianling.dynamic.model.TrendsListBean;
import com.ydl.ydlcommon.utils.MoonUtil;
import com.ydl.ydlcommon.view.BaseViewHolder;

import java.util.List;

/**
 * Created by Jim on 2017/9/27 0027.
 */

public class ItemCommentsAdapter extends RecyclerView.Adapter<BaseViewHolder> {

    private List<TrendsListBean.Trend.Comments> mComments;
    private Context mContext;

    public interface OnItemClickLister {
        void onItemClick(View view, int position);
    }

    private OnItemClickLister mOnItemClickLister;

    public void setOnItemClickLister(OnItemClickLister onItemClickLister) {
        mOnItemClickLister = onItemClickLister;
    }

    public ItemCommentsAdapter(Context context, List<TrendsListBean.Trend.Comments> commentses) {
        mComments = commentses;
        mContext = context;
    }

    @Override
    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.dynamic_item_discuss_list, parent, false);
        return new BaseViewHolder(view, parent.getContext(), viewType);
    }

    @Override
    public void onBindViewHolder(BaseViewHolder holder, int position) {
        TrendsListBean.Trend.Comments comment = mComments.get(position);
        String toName = null;
        String name = comment.name.trim();
        if (!TextUtils.isEmpty(comment.to_name)) {
            toName = comment.to_name.trim();
        }
        String content = comment.content.trim();
        LogUtil.d("comment: " + content + " toName: " + toName);
        MoonUtil.SetDicuss(mContext, holder.getView(R.id.item_dicuss_tv), content, name, toName, ImageSpan.ALIGN_BOTTOM);
        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mOnItemClickLister != null) {
                    mOnItemClickLister.onItemClick(holder.itemView, position);
                }
            }
        });
    }

    @Override
    public int getItemCount() {
        if (mComments != null && mComments.size() > 0) {
            return mComments.size() > 3 ? 3 : mComments.size();
        }
        return 0;
    }
}
