package com.yidianling.dynamic.trendsDetail;


import androidx.appcompat.app.AppCompatActivity;

import com.ydl.ydlcommon.mvp.base.IPresenter;
import com.yidianling.dynamic.model.CommentBean;
import com.yidianling.dynamic.model.ExpertBuild;
import com.yidianling.dynamic.model.Focus;
import com.yidianling.dynamic.model.Reply;
import com.yidianling.dynamic.model.TrendsDetailInfoBean;
import com.yidianling.dynamic.model.ZanResult;
import com.ydl.ydlcommon.data.http.BaseAPIResponse;
import com.ydl.ydlcommon.data.http.BaseResponse;

import java.util.List;

/**
 * Created by Jim on 2017/10/28 0028.
 */

public interface ITrendsDetailPresenter extends IPresenter<ITrendsDetailView> {
    interface OnTrendsDetailDataLoadFinishedListenner {
        void onTrendsDetailFetched(BaseAPIResponse<TrendsDetailInfoBean> trendsDetailInfoBeanBaseBean);

        void onTrendsDetailFetchFailed(Throwable e);

        void onCommentsListFetched(List<CommentBean> commentsBean);

        void onCommentsListFetchedFailed(Throwable e);

        void ondoLikeActionFetchedResult(BaseResponse<ZanResult> zanResultBaseBean, int type);

        void onFoucusActionSuccessed(BaseResponse<Focus> response);

        void onReportContentFetched(BaseResponse response, int answerId, String commentContent);

        void onReportSuccessed(BaseResponse<Object> response);

        void onGetExpertSuccesssed(BaseResponse<ExpertBuild> response);

        void onCommentOrReplySuccessed(BaseResponse<Reply> replyBaseResponse, int type, String content, String replyContent, String toName);

        void onDeleteSuccessed(BaseResponse<Object> response, int type, int position);

        void showDataLoadErrorView(Throwable e);
    }

    public void fetchTrendsDetails(int id);


    public void fetchCommentsDatas(int id, int page, int lastId, int direction);

    /**
     * 点赞
     */
    public void doLikeAction(int type, int id);


    public void focus(String uid);

    /**
     * //获取举报的内容列表
     */
    public void fetchReportReasonContent(int answerId, String commentContent);


    //举报帖子评论
    public void report(int trendId, int type, int reasonId, int answerId, String answerContent);


    /**
     * //删除帖子或评论
     *
     * @param type 移除类型：1移除评论，2移除动态
     * @param id   评论的id,动态id
     */
    public void delTrendsReply(int type, int id, int position);

    public void getExpert(AppCompatActivity activity, String expertUid);

    public void commitOrReply(int type, String tid, String content, String replyContent, String toName);
}
