package com.yidianling.fm.router

import android.app.Activity
import android.content.Context
import android.content.Intent
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.yidianling.dynamic.api.IDynamicService
import com.yidianling.user.api.service.IAppService
import com.yidianling.user.api.service.IUserService

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/04/25
 */
object FMIn {
    fun getAppService(): IAppService {
        return ModularServiceManager.provide(IAppService::class.java)
    }

    fun getDynamicService(): IDynamicService {
        return ModularServiceManager.provide(IDynamicService::class.java)
    }

    fun isLogin(): Boolean {
        return ModularServiceManager.provide(IUserService::class.java).isLogin()
    }

    fun mainIntent(activity: Activity){
        getAppService().mainIntent(activity)
    }

    fun loginWayIntent(activity: Activity): Intent? {
        return ModularServiceManager.provide(IUserService::class.java).loginWayIntent(activity)
    }

    /**
     * FM分享到心事动态
     */
    fun publisFmToTrend(activity: Activity, url: String, cover: String, title: String) : Intent?{
        return getDynamicService()?.publishFmToTrend(activity,url,cover,title)
    }
    /**
     * 调用优先使用一键登录，并返回调用时的登录状态，
     * @param isOpenDialog true:一键登录使用弹窗展示 false:一键登录使用全屏模式
     * @return true：已登录，不触发登录跳转，false：未登录，优先一键登录
     * */
    fun loginByOneKeyLogin(context: Context,isOpenDialog: Boolean) :Boolean{
        return ModularServiceManager.provide(IUserService::class.java).loginByOneKeyLogin(context,isOpenDialog)
    }

}