package com.yidianling.home.model

import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.RxUtils
import com.yidianling.home.constants.IHomeBaseContract
import com.yidianling.home.http.HomeBaseHttp
import com.yidianling.home.model.bean.*
import io.reactivex.Observable
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers

open class BaseHomeModelImpl : IHomeBaseContract.Model {

    /**
     * 首页咨询请求
     */
    override fun consultRequest(category: String): Observable<HomeConsultBean> {
        return HomeBaseHttp.getInstance().getConsultData(category).compose(RxUtils.resultJavaData())
            .onErrorReturn { HomeConsultBean(true) }
    }

    /**
     * 首页问答 - 点赞
     */
    override fun askZan(id: String): Observable<AskResultBean> {
        return HomeBaseHttp.getInstance().askZan(id).compose(RxUtils.resultData())
    }

    /**
     * 首页问答 - 关注
     */
    override fun askFocus(id: String): Observable<AskResultBean> {
        return HomeBaseHttp.getInstance().askFocus(id).compose(RxUtils.resultData())
    }

    /**
     * 首页电台请求
     */
    override fun fmRequest(): Observable<HomeFMBean> {
        return HomeBaseHttp.getInstance().getFMData().compose(RxUtils.resultJavaData())
            .onErrorReturn { HomeFMBean(true) }
    }

    /**
     * 首页课程请求
     */
    override fun courseRequest(): Observable<HomeCourseBean> {
        return HomeBaseHttp.getInstance().getCourseData().compose(RxUtils.resultJavaData())
            .onErrorReturn { HomeCourseBean(true) }
    }

    /**
     * 首页测试题请求
     */
    override fun testRequest(): Observable<BaseAPIResponse<MutableList<HomeTestItemBean>>> {
        return HomeBaseHttp.getInstance().getTestData()
    }

    /**
     * 首页倾听请求
     */
    override fun confideRequest(goodType: String): Observable<HomeConfideBean> {
        return HomeBaseHttp.getInstance().getConfideData(goodType).compose(RxUtils.resultJavaData())
            .onErrorReturn { HomeConfideBean(true) }
    }

    /**
     * 首页问答请求
     */
    override fun askRequest(): Observable<HomeAskBean> {
        return HomeBaseHttp.getInstance().getAskData().compose(RxUtils.resultJavaData())
            .onErrorReturn { HomeAskBean(true) }
    }

    /**
     * 首页文章请求
     */
    override fun articleRequest(): Observable<HomeArticleBean> {
        return HomeBaseHttp.getInstance().getArticleData().compose(RxUtils.resultJavaData())
            .onErrorReturn { HomeArticleBean(true) }
    }

    /**
     * 首页头部 分类&Banner请求
     */
    override fun headerRequest(): Observable<HomeHeaderBean> {
        return HomeBaseHttp.getInstance().newHomeHeaderRequest().compose(RxUtils.resultJavaData())
            .onErrorReturn { HomeHeaderBean(true) }
    }
}