package com.yidianling.home.model.bean

import com.google.gson.annotations.SerializedName

/**
 * Created by haorui on 2019/2/14.
 * Des:首页问答模块参数
 */
class HomeAskBean : HomeItemBaseBean {
    constructor():super(false)
    constructor(isRealEmpty:Boolean):super(isRealEmpty)

    var data: MutableList<DataBean>? = null
    @SerializedName(value = "ext_data", alternate = ["extData"])
    var ext_data: List<ExtDataBean>? = null
    var bannerResps: List<BannerResp>? = null

    class BannerResp {
        var bannerId: Int? = 0 //bannerId ,
        var bannerImageUrl: String? = null //图片地址 ,
        var bannerLinkUrl: String? = null //链接地址 ,
        var bannerTitle: String? = null //标题
    }

    class DataBean {
        /**
         * askId
         */
        var id: Int = 0
        /**
         * 问答创建时间
         */
        @SerializedName(value = "timeStr", alternate = ["time_str"])
        var timeStr: String? = null
        /**
         * 浏览数量，点击数量
         */
        var hits: Int = 0
        /**
         * 问题的标题
         */
        var title: String? = null
        /**
         * 内容类型：1纯文本，2图片，3图文，4url链接和app内部跳转
         */
        var multitextType: Int = 0
        /**
         * 话题id，1:心事问答
         */
        var topicId: Int = 0
        /**
         * 回帖量
         */
        var replyCounter: Int = 0
        /**
         * multitype=4时候添加到这个字段，json格式4:{url: '',cover:'',topicTitle:''}
         */
        var extContent: String? = null
        /**
         * 问答发布内容
         */
        var content: String? = null
        /**
         * 问答发布者uid，匿名为0
         */
        var uid: Int = 0
        /**
         * 问答发布显示名称，匿名null
         */
        var name: String? = null
        /**
         * 问答发布者性别
         */
        var gender: Int = 0
        /**
         * 问答标签
         */
        var askTag: String? = null
        /**
         * 总的温暖数量
         */
        var zanCount: Int = 0
        /**
         * 问答发布者头像，匿名为null
         */
        var avatar: String? = null
        /**
         * 安卓，问答发布者头像，匿名为null
         */
        var header: String? = null
        /**
         * 评论数
         */
        var commentsCount: Int = 0
        /**
         * 话题的标题
         */
        var topicTitle: String? = null
        /**
         * 点赞id，0为未点赞
         */
        var isZan: Int = 0
        /**
         * 访问量
         */
        var visitCount: Int = 0
        /**
         * 来自平台
         */
        var from: String? = null
        var utype: Int = 0
        /**
         * 是否为广告
         */
        @SerializedName(value = "isAd", alternate = ["is_ad"])
        var isAd: Int = 0
        /**
         * 广告的跳转
         */
        var url: String? = null
        var adImg: String? = null
        var focId: Int = 0
        /**
         * 是否关注 1关注
         */
        var isFocused: Int = 0
        var share: Any? = null
        var isSelf: Int = 0
        /**
         * multitype=4,5时候添加到这个字段，json格式4:{url: '',cover:'',title:''};5待定
         */
        var ext: Any? = null
        /**
         * 附件
         */
        var smallAttach: List<*>? = null
        /**
         * 附件
         */
        var bigAttach: List<*>? = null
        /**
         * 问答答案列表
         */
        var comments: List<CommentsBean>? = null

        class CommentsBean {
            /**
             * 评论用户显示姓名
             */
            var name: String? = null
            /**
             * 评论内容
             */
            var content: String? = null
            /**
             * 文章评论专家姓名
             */
            @SerializedName(value = "toName", alternate = ["to_name"])
            var toName: String? = null
            /**
             * 评论用户头像
             */
            var userHead: String? = null
            /**
             * 评论发表时间
             */
            var answerCreateTime: String? = null
            /**
             * 问答创建时间
             */
            var time_str: String? = null
            /**
             * 文章评论内容
             */
            @SerializedName(value = "toContent", alternate = ["to_content"])
            var toContent: String? = null
            /**
             * 文章评论id
             */
            var id: Int = 0
            /**
             * 评论用户id
             */
            var uid: Int = 0
            /**
             * 评论问答id
             */
            var askId: Int = 0
            var zan: Int = 0
            /**
             * 文章评论用户性别
             */
            var gender: Int = 0
            /**
             * 文章评论用户类型, 2则为专家
             */
            @SerializedName(value = "userType", alternate = ["user_type"])
            var userType: Int = 0
            /**
             * 文章评论专家id
             */
            @SerializedName(value = "doctorId", alternate = ["doctor_id"])
            var doctorId: Int = 0
            /**
             * 是否开通倾诉 0-否 1-是
             */
            var isOpenListen: Int = 0
            /**
             * 是否空闲 0-否 1-是
             */
            var isAvailable: Int = 0
            /**
             * 倾诉链接
             */
            var listenLinkUrl: String? = null


        }
    }

    class ExtDataBean {
        var id: Int = 0
        var type: Int = 0
        var parentId: Int = 0
        var status: Int = 0
        var doctorId: Int = 0
        var uid: Int = 0
        var createTime: String? = null
        var updateTime: Any? = null
        var deleteTime: Any? = null
        var deleteUser: String? = null
        var isDelete: Int = 0
        var hits: Int = 0
        var tags: String? = null
        var tags2: String? = null
        var askSource: String? = null
        var ffrom: String? = null
        var fsid: String? = null
        var browser: String? = null
        var favTotalNum: Int = 0
        var ip: String? = null
        var title: String? = null
        var showTips: Any? = null
        var channel: String? = null
        var platform: String? = null
        var isTop: Int = 0
        var zhuishuTop: Int = 0
        var multitextType: Any? = null
        var topicId: Int = 0
        var isPublish: Any? = null
        var isHot: Any? = null
        var replyCounter: Int = 0
        var zanCounter: Int = 0
        var extContent: String? = null
        var hotTime: Int = 0
        var topTime: Int = 0
        var anonymous: Any? = null
        var checkStatus: Any? = null
        var operateStatus: Any? = null
        var topRule: Any? = null
        var topPage: Any? = null
        var isDoctorShow: Any? = null
        var content: String? = null
    }
}
