package com.yidianling.home.ui.view

import android.content.Context
import android.graphics.Color
import android.graphics.drawable.Drawable
import android.text.*
import android.text.style.ForegroundColorSpan
import android.text.style.ImageSpan
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import android.widget.TextView
import com.ydl.ydl_image.manager.YDLImageCacheManager
import com.ydl.ydl_router.manager.YDLRouterManager
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.ydl.ydlcommon.router.IYDLRouterConstant
import com.ydl.ydlcommon.utils.MoonUtil
import com.ydl.ydlcommon.utils.Utils
import com.yidianling.common.tools.RxDeviceTool
import com.yidianling.common.tools.RxImageTool
import com.yidianling.home.R
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeAskBean
import com.yidianling.user.api.service.IUserService
import kotlinx.android.synthetic.xlzx.home_assuage_grief_item_view.view.*


/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 解忧*问答模块item
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/15
 */
class HomeAssuageGriefItemView(
    private val mContext: Context,
    private var homeEvent: IHomeBaseEvent?
) : LinearLayout(mContext) {

    private var homeAssuageGriefImageItemView: HomeAssuageGriefImageItemView? = null
    private var focusClick: Boolean = false;

    init {
        initView()
    }

    private fun initView() {
        val params = LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.WRAP_CONTENT
        )
        layoutParams = params
        View.inflate(mContext, R.layout.home_assuage_grief_item_view, this)


    }

    fun updateData(bean: HomeAskBean.DataBean, position: Int, index: Int, isBottomItem: Boolean) {
        this.setOnClickListener {
            homeEvent?.askItemClick(bean)
        }
        MoonUtil.identifyFaceExpression(
            mContext, homeModuleAssuageGriefViewContent,
            bean?.content, ImageSpan.ALIGN_BOTTOM
        )
        homeModuleAssuageGriefViewTag.text = bean?.askTag
        homeModuleAssuageGriefViewCommentsCount.text = bean?.commentsCount.toString()
        homeModuleAssuageGriefViewZanCount.text = bean?.zanCount.toString()

        if (isBottomItem) {
            homeModuleAssuageGriefViewBottomLine.visibility = View.GONE
            homeModuleAssuageGriefViewBottomBtn.visibility = View.VISIBLE
            homeModuleAssuageGriefViewBottomBtn.setOnClickListener {
                homeEvent?.askMoreClick()
            }
        } else {
            homeModuleAssuageGriefViewBottomLine.visibility = View.VISIBLE
            homeModuleAssuageGriefViewBottomBtn.visibility = View.GONE
        }


        /**
         * 点赞
         */
        ll_zan.setOnClickListener {
            if (!Utils.isFastClick()) {
                if (!ModularServiceManager.provide(IUserService::class.java).isLogin()) {
                    //跳转登录
                    YDLRouterManager.router(IYDLRouterConstant.ROUTER_MINE_LOGIN)
                    return@setOnClickListener
                }
                bean.isZan = if (bean.isZan == 1) 0 else 1
                if (bean.isZan == 1) {
                    homeModuleAssuageGriefViewZanState.setImageResource(R.drawable.home_assuage_grief_item_view_tab_warm_has_zan)
                } else {
                    homeModuleAssuageGriefViewZanState.setImageResource(R.drawable.home_assuage_grief_item_view_tab_warm)
                }
                bean.zanCount = if (bean.isZan == 1) bean.zanCount + 1 else bean.zanCount - 1
                homeModuleAssuageGriefViewZanCount.text = bean?.zanCount.toString()

                //防止连击
                homeEvent?.askItemZanClick(position, index, bean.id.toString())
            }
        }

        /**
         * 标题
         */
        if (!TextUtils.isEmpty(bean?.title)) {
            homeModuleAssuageGriefViewTitle.visibility = View.VISIBLE
            homeModuleAssuageGriefViewTitle.text = bean?.title
        }

        /**
         * 点赞
         */
        if (bean?.isZan == 1) {
            homeModuleAssuageGriefViewZanState.setImageResource(R.drawable.home_assuage_grief_item_view_tab_warm_has_zan)
        } else {
            homeModuleAssuageGriefViewZanState.setImageResource(R.drawable.home_assuage_grief_item_view_tab_warm)
        }

        /**
         * 图片
         */
        if (null != bean?.smallAttach && bean?.smallAttach!!.isNotEmpty()) {
            if (homeAssuageGriefImageItemView != null) {
                homeModuleAssuageGriefItemImageItemLL.removeAllViews()
                homeModuleAssuageGriefItemImageItemLL.visibility = View.GONE
            }
            homeAssuageGriefImageItemView = HomeAssuageGriefImageItemView(
                mContext,
                bean?.smallAttach as List<String>,
                homeEvent
            )
            homeModuleAssuageGriefItemImageItemLL.addView(homeAssuageGriefImageItemView)
            homeModuleAssuageGriefItemImageItemLL.visibility = View.VISIBLE
        } else {
            if (null != homeAssuageGriefImageItemView) {
                homeModuleAssuageGriefItemImageItemLL.removeAllViews()
                homeModuleAssuageGriefItemImageItemLL.visibility = View.GONE
            }
        }

        /**
         * 评论
         */
        initComment(bean)

    }

    private fun initComment(bean: HomeAskBean.DataBean) {
        if (bean?.commentsCount > 0) {
            homeModuleAssuageGriefViewComment.visibility = View.VISIBLE

            var index: Int = 0
            var commentBean = bean?.comments!![0]

            YDLImageCacheManager.showImage(mContext, commentBean.userHead, homeModuleAssuageGriefViewHotViewHeader)

            if (null != commentBean.name && commentBean.name!!.isNotEmpty())
                homeModuleAssuageGriefViewHotViewComment.text = commentBean.name?:""

            // userType为2 ，专家
            if (commentBean.userType == 2) {
                homeModuleAssuageGriefViewHotViewVip.visibility = View.VISIBLE
            } else {
                homeModuleAssuageGriefViewHotViewVip.visibility = View.GONE
            }

            homeModuleAssuageGriefViewHotViewCommentContent.text = commentBean.content?:""

        } else {
            homeModuleAssuageGriefViewComment.visibility = View.GONE
        }
    }
}