package com.yidianling.home.ui.view

import android.content.Context
import android.graphics.Color
import android.text.TextUtils
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import androidx.core.content.ContextCompat
import com.ydl.ydl_image.manager.YDLImageCacheManager
import com.ydl.ydlcommon.utils.URLUtils
import com.yidianling.common.tools.RxImageTool
import com.yidianling.home.R
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeConsultBean
import kotlinx.android.synthetic.xlzx.home_consult_item_view.view.*
import java.math.BigDecimal

/**
 * @author jiucheng
 * @描述:首页咨询理解模块--专家个人信息view
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/2/16
 */
class HomeConsultItemView(private var mContext: Context, private var homeEvent: IHomeBaseEvent?) :
    FrameLayout(mContext) {
    private var dp70 = 0

    init {
        initView()

        dp70 = RxImageTool.dip2px(70f)
    }

    private fun initView() {
        var params = FrameLayout.LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.WRAP_CONTENT
        )
        layoutParams = params
        View.inflate(context, R.layout.home_consult_item_view, this)
    }

    fun setData(bean: HomeConsultBean.ListBean?, position: Int, isLast: Boolean, cateId: String?) {
        if (bean == null) {
            visibility = View.GONE
            return
        }
        //设置头像
        setHead(bean)
        //设置名称
        tv_consult_name.text = bean.name
        //设置接通率文案
        setConnection(bean)
        //设置向TA咨询人数
        setConfideNum(bean)
        //设置向TA咨询按钮状态
        setConfideButton(bean)

        setOnClickListener {
            val url = URLUtils.appendParmas(bean.linkUrl, "cateId", cateId)
            homeEvent!!.consultItemClick(url, bean.doctorId)
        }
    }

    /**
     * 设置头像
     */
    private fun setHead(bean: HomeConsultBean.ListBean) {
        YDLImageCacheManager.showImage(mContext, bean?.head, img_consult_head)
    }

    /**
     * 设置向TA咨询人数
     */
    private fun setConfideNum(bodyBean: HomeConsultBean.ListBean) {
        if (TextUtils.isEmpty(bodyBean.zixunOrderNum.toString())) {
            tv_consult_num.visibility = View.GONE
        } else {
            tv_consult_num.visibility = View.VISIBLE
            tv_consult_num.text = "咨询次数${bodyBean.zixunOrderNum}"
        }
    }

    /**
     * 设置接通率文案
     */
    private fun setConnection(bodyBean: HomeConsultBean.ListBean) {
        if (TextUtils.isEmpty(bodyBean.feedbackRate.toString())) {
            tv_feedback_rate.visibility = View.INVISIBLE
        } else {
            tv_feedback_rate.visibility = View.VISIBLE
            try {
                val d = BigDecimal(bodyBean.feedbackRate.toString()).setScale(1, BigDecimal.ROUND_DOWN)
                val str = d.toString()
                tv_feedback_rate.text = str
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
    }

    /**
     * 设置向TA倾诉按钮状态
     */
    private fun setConfideButton(bodyBean: HomeConsultBean.ListBean) {
        //私聊文案
        if (TextUtils.isEmpty(bodyBean.chatBtnText)) {
            tv_consult_chat.text = "私聊"
            tv_consult_chat.setTextColor(Color.parseColor("#FD9B0A"))
        } else {
            tv_consult_chat.text = bodyBean.chatBtnText
            tv_consult_chat.setTextColor(
                ContextCompat.getColor(
                    context,
                    R.color.platform_color_999999
                )
            )
        }


        tv_consult_chat.setOnClickListener {
            homeEvent!!.consultChatClick(bodyBean.uid.toString())
        }
    }
}
