package com.yidianling.home.ui.view

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.yidianling.home.R
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeFMBean
import kotlinx.android.synthetic.xlzx.home_intelligent_view.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 心灵*电台模块
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/13
 */
class HomeIntelligentView(private val mContext: Context, private var homeEvent: IHomeBaseEvent?) :
    LinearLayout(mContext) {

    private var cacheList: ArrayList<HomeFMBean.ListBean> = ArrayList()

    init {
        initView()
    }

    private fun initView() {
        orientation = VERTICAL
        val params = LinearLayout.LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.WRAP_CONTENT
        )
        layoutParams = params
        View.inflate(mContext, R.layout.home_intelligent_view, this)
        homeModuleIntelligentViewHomeCommonTitleView.setTitle("心灵·电台")
        homeModuleIntelligentViewHomeCommonTitleView.setOnClickListener {
            homeEvent?.fmMoreClick()
        }
    }

    fun initData(list: List<HomeFMBean.ListBean>?) {
        //添加View
        if (list == null) {
            return
        }
        if (cacheList.size != list?.size) {
            cacheList.clear()
            cacheList.addAll(list)
            updateHomeIntelligentItemViewNumber()
        }
        //刷新数据
        for (index in 0 until homeModuleIntelligentViewAddLayout.childCount) {
            val itemView = homeModuleIntelligentViewAddLayout.getChildAt(index)
            if (itemView is HomeIntelligentItemView) {
                //第一个这种类型item，需要设置marginTop = 16dp,最后一个item需要设置marginBototm = 16dp
                if (index == 1) {
                    itemView.setTopMargin()
                } else if (index == homeModuleIntelligentViewAddLayout.childCount - 1) {
                    itemView.setBottomMargin()
                }
                itemView.updateData(list[index])
            } else if (itemView is HomeIntelligentTopItemView) {
                itemView.updateData(list[index])
            }
        }
    }

    /**
     * 更新itemView的数量以适应新的数据集
     */
    private fun updateHomeIntelligentItemViewNumber() {
        var childCountRecord = homeModuleIntelligentViewAddLayout.childCount
        while (cacheList.size > childCountRecord) {
            if (childCountRecord == 0) {
                homeModuleIntelligentViewAddLayout.addView(
                    HomeIntelligentTopItemView(
                        mContext,
                        homeEvent
                    )
                )
            } else {
                homeModuleIntelligentViewAddLayout.addView(
                    HomeIntelligentItemView(
                        mContext,
                        homeEvent
                    )
                )
            }
            childCountRecord++
        }
        while (cacheList.size < childCountRecord &&
            (homeModuleIntelligentViewAddLayout.getChildAt(childCountRecord - 1) is HomeIntelligentItemView
                    || homeModuleIntelligentViewAddLayout.getChildAt(childCountRecord - 1) is HomeIntelligentTopItemView)
        ) {
            homeModuleIntelligentViewAddLayout.removeViewAt(childCountRecord - 1)
            childCountRecord--
        }
    }
}