package com.yidianling.home.ui.view

import android.content.Context
import android.view.View
import android.widget.LinearLayout
import com.yidianling.home.R
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeTestItemBean
import kotlinx.android.synthetic.xlzx.home_test_top_item_view.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 测评模块item--顶部item
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/15
 */
class HomeTestTopItemView(private val mContext: Context, private var homeEvent: IHomeBaseEvent?) :
    LinearLayout(mContext) {

    init {
        initView()
    }

    private fun initView() {
        View.inflate(mContext, R.layout.home_test_top_item_view, this)
    }

    /**
     * 刷新数据
     */
    fun updateData(bean: HomeTestItemBean) {

        homeModuleTestTopViewTitle.text = bean.name
        var numStr = ""
        if (bean.testNum >= 10000) {
            numStr = String.format("%.1f", (bean.testNum / 10000.0)) + "万"
        } else {
            numStr = bean.testNum.toString()
        }
        homeModuleTestTopViewHits.text = numStr + "人已测"

        this.setOnClickListener {
            homeEvent?.testItemClick(bean.recommendLinkUrl)
        }
    }
}