package com.yidianling.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import androidx.recyclerview.widget.RecyclerView
import com.ydl.ydl_image.module.GlideApp
import com.yidianling.home.R
import com.yidianling.home.constract.HomeViewConfig
import com.yidianling.home.event.HomeImpl
import com.yidianling.home.model.bean.*
import com.yidianling.home.ui.view.*


/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 壹点零首页适配器
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/13
 */
class YdlHomeAdapter(private val mContext: Context,
                     private var homeEvent: HomeImpl,
                     private var list: ArrayList<HomePagerDataBean>) : RecyclerView.Adapter<RecyclerView.ViewHolder>() {

    private val mInflater: LayoutInflater = LayoutInflater.from(mContext)
    /**
     * 倾述item的position
     *
     */
    private var confidePosition = -1

    /**
     * 咨询条目 position
     */
    private var consultPosition = -1

    /**
     * 倾述模块中tab上次选中的下标
     */
    var confideSelectPosition = 0

    /**
     * 咨询模块中tab上次选中的下标
     */
    var consultSelectPosition = 0

    /**
     * 倾诉分类 缓存
     */
    var listenCategoryDate: List<HomeHeaderBean.ListenCategoryDateBean>? = null

    /**
     * 咨询分类 缓存
     */
    var consultCategoryData: List<HomeHeaderBean.ConsultCategoryDateBean>? = null

    fun updateItems(list: MutableList<HomePagerDataBean>) {
        if (null == this.list || this.list!!.isEmpty()) {
            this.list = ArrayList()
        } else {
            this.list.clear()
        }
        this.list.addAll(list)
        //重置标记位
        confidePosition = -1
        consultPosition = -1
        notifyDataSetChanged()
    }

    /**
     * 更新倾诉模块数据
     */
    fun updateConfideData(data: HomeConfideBean, selectPosition: Int) {
        if (confidePosition == -1) {
            return
        }
        list[confidePosition].confideBean = data
        this.confideSelectPosition = selectPosition
        notifyItemChanged(confidePosition)
    }

    /**
     * 更新咨询模块数据
     */
    fun updateConsultData(data: HomeConsultBean, selectPosition: Int) {
        if (consultPosition == -1) {
            return
        }
        list[consultPosition].consultBean = data
        this.consultSelectPosition = selectPosition
        notifyItemChanged(consultPosition)
    }

    /**
     * 更新问答模块数据
     */
    fun updateAskData(data: HomeAskBean, position: Int) {
        list[position].askBean = data
//        notifyItemChanged(position)
    }

    override fun getItemViewType(position: Int): Int {
        if (position < list.size) {
            return list[position].type!!
        } else {
            return -1
        }
    }


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        when (viewType) {
            //顶部ViewPager与分类模块
            HomeViewConfig.getOrder().bannerIndex -> {
                if (viewType == -1){
                    //空布局
                    val view = View(mContext)
                    val layoutParams = ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,1)
                    view.layoutParams = layoutParams
                    view.visibility = View.GONE
                    return HomePagerBannerViewHolder(view,viewType)
                }
                return HomePagerBannerViewHolder(HomePagerBannerView(mContext, homeEvent),viewType)
            }
            //咨询模块
            HomeViewConfig.getOrder().consultIndex -> {
                return HomeConsultViewHolder(HomeConsultView(mContext, homeEvent),viewType)
            }
            //顶部预约专家，即时倾诉，心理测试按钮模块
            HomeViewConfig.getOrder().buttonIndex -> {
                return HomeButtonBannerViewHolder(HomeButtonBannerView(mContext, homeEvent),viewType)
            }
            //倾诉*排解模块
            HomeViewConfig.getOrder().confideIndex -> {
                return HomeConfideViewHolder(HomeConfideView(mContext, homeEvent),viewType)
            }
            //课程*成长模块
            HomeViewConfig.getOrder().courseIndex -> {
                return HomeCourseViewHolder(HomeCourseView(mContext, homeEvent),viewType)
            }
            //解忧*问答模块
            HomeViewConfig.getOrder().dynamicIndex -> {
                return HomeAssuageGriefViewHolder(HomeAssuageGriefView(mContext, homeEvent),viewType)
            }
            //测试模块
            HomeViewConfig.getOrder().testsIndex -> {
                return HomeTestViewHolder(HomeTestView(mContext, homeEvent),viewType)
            }
            //心灵*电台模块
            HomeViewConfig.getOrder().fmIndex -> {
                return HomeIntelligentViewHolder(HomeIntelligentView(mContext, homeEvent),viewType)
            }
            //文章*阅读模块
            HomeViewConfig.getOrder().articleIndex -> {
                return HomeArticleViewHolder(HomeArticleView(mContext, homeEvent),viewType)
            }
            //壹点*冥想模块
            HomeViewConfig.getOrder().museIndex -> {
                return HomeMuseViewHolder(HomeMuseView(mContext, homeEvent),viewType)
            }
            //底部提示语模块
            else -> {
                val view = mInflater.inflate(R.layout.home_footer_view, parent, false)
                return FooterViewViewHolder(view,viewType)
            }
        }
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        when (holder) {
            //顶部ViewPager与分类模块
            is HomePagerBannerViewHolder -> {
                var tempIndex =  if (holder.viewType==-1) 0 else holder.viewType
                var headerBean = list[tempIndex].headerBean;
                this.consultCategoryData = headerBean?.consultCategoryData
                this.listenCategoryDate = headerBean?.listenCategoryDate

                if (holder.viewType !=-1){
                    holder.pagerBannerView as HomePagerBannerView
                    holder.pagerBannerView.initData(headerBean)
                }
            }
            //顶部预约专家，即时倾诉，心理课堂，心理测试按钮模块
            is HomeButtonBannerViewHolder -> {
            }
            //咨询模块
            is HomeConsultViewHolder -> {
                holder.consultView.setTitle(this.consultCategoryData, consultSelectPosition)
                holder.consultView.setConsultInfoView(list[holder.viewType].consultBean?.list,this.consultCategoryData?.get(consultSelectPosition))
                consultPosition = position
            }
            //倾诉*排解模块
            is HomeConfideViewHolder -> {
                holder.confideViewView.setTitle(this.listenCategoryDate, confideSelectPosition)
                holder.confideViewView.setConfideExpertInfoView(list[holder.viewType].confideBean?.body)
                confidePosition = position
            }
            //课程*成长模块
            is HomeCourseViewHolder -> {
                holder.courseViewView.initData(list[holder.viewType].courseBean?.list)
            }
            //解忧*问答模块
            is HomeAssuageGriefViewHolder -> {
                holder.assuageGriefViewView.initData(position,list[holder.viewType].askBean?.data)
            }
            //壹点*冥想模块
            is HomeMuseViewHolder -> {
                holder.museViewView.initData(list[holder.viewType].museBean)
            }
            //心灵*电台模块
            is HomeIntelligentViewHolder -> {
                holder.intelligentViewView.initData(list[holder.viewType].fmBean?.list)
            }
            //文章*阅读模块
            is HomeArticleViewHolder -> {
                holder.articleViewView.initData(list[holder.viewType].articleBean?.list)
            }
            //测试模块
            is HomeTestViewHolder -> {
                holder.testView.initData(list[holder.viewType].testListBean)
            }
        }
    }

    override fun getItemCount(): Int {
        return list.size
    }

    /**
     * 顶部ViewPager与分类模块 ViewHolder
     */
    inner class HomePagerBannerViewHolder(val pagerBannerView: View,val viewType:Int) : RecyclerView.ViewHolder(pagerBannerView)

    /**
     * 顶部预约专家，即时倾诉，心理测试按钮模块 ViewHolder
     */
    inner class HomeButtonBannerViewHolder(val buttonBannerView: HomeButtonBannerView,val viewType:Int) : RecyclerView.ViewHolder(buttonBannerView)

    /**
     * 咨询模块 ViewHolder
     */
    inner class HomeConsultViewHolder(val consultView: HomeConsultView,val viewType:Int) : RecyclerView.ViewHolder(consultView)

    /**
     * 倾诉*排解模块 ViewHolder
     */
    inner class HomeConfideViewHolder(val confideViewView: HomeConfideView,val viewType:Int) : RecyclerView.ViewHolder(confideViewView)

    /**
     * 课程*成长模块 ViewHolder
     */
    inner class HomeCourseViewHolder(val courseViewView: HomeCourseView,val viewType:Int) : RecyclerView.ViewHolder(courseViewView)

    /**
     * 测试模块 ViewHolder
     */
    inner class HomeTestViewHolder(val testView: HomeTestView,val viewType:Int) : RecyclerView.ViewHolder(testView)

    /**
     * 解忧*问答模块 ViewHolder
     */
    inner class HomeAssuageGriefViewHolder(val assuageGriefViewView: HomeAssuageGriefView,val viewType:Int) : RecyclerView.ViewHolder(assuageGriefViewView)

    /**
     * 心灵*电台模块 ViewHolder
     */
    inner class HomeIntelligentViewHolder(val intelligentViewView: HomeIntelligentView,val viewType:Int) : RecyclerView.ViewHolder(intelligentViewView)

    /**
     * 文章*阅读模块 ViewHolder
     */
    inner class HomeMuseViewHolder(val museViewView: HomeMuseView,val viewType:Int) : RecyclerView.ViewHolder(museViewView)

    /**
     * 文章*阅读模块 ViewHolder
     */
    inner class HomeArticleViewHolder(val articleViewView: HomeArticleView,val viewType:Int) : RecyclerView.ViewHolder(articleViewView)

    /**
     * 底部提示语模块 ViewHolder
     */
    inner class FooterViewViewHolder(val footerView: View,val viewType:Int) : RecyclerView.ViewHolder(footerView){
        var imageLogoView:ImageView?=null

        init {
            imageLogoView=footerView.findViewById(R.id.iv_logo_view);
            GlideApp.with(mContext).load("https://static.yidianling.com/banner/bottombanner@2x.png").into(imageLogoView);
        }
    }
}