package com.yidianling.home.dialog

import android.app.Activity
import android.app.Dialog
import android.os.Bundle
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydl_image.module.GlideApp
import com.ydl.ydl_router.manager.YDLRouterManager
import com.yidianling.home.R
import kotlinx.android.synthetic.ydl.home_dialog_activity.*
import java.lang.ref.WeakReference

/**
 * 活动弹窗
 */
class ActivityDialog : Dialog {

    private var imgUrl: String? = null
    private var linkUrl: String? = null
    private var title: String? = null
    private var mActivity: WeakReference<Activity>? = null

    constructor(activit: Activity, imgUrl: String?, linkUrl: String?, title: String?) : super(
        activit,
        R.style.activityDialog
    ) {
        this.imgUrl = imgUrl
        this.linkUrl = linkUrl
        this.title = title
        this.mActivity = WeakReference<Activity>(activit)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        window.setBackgroundDrawableResource(android.R.color.transparent)

        setContentView(R.layout.home_dialog_activity)

        initView()
    }

    private fun initView() {
        img_close.setOnClickListener {
            this.dismiss()

        }
        img_activity.setOnClickListener {
            //跳转
            if (this.linkUrl != null && this.linkUrl!!.startsWith("http")) {
                NewH5Activity.start(context, H5Params(this.linkUrl!!, null))
            } else {
                YDLRouterManager.router(this.linkUrl)
            }
        }
        GlideApp.with(context).load(imgUrl).into(img_activity)

        setCanceledOnTouchOutside(false)
        setCancelable(false)
    }

}
