package com.yidianling.home.model

import com.ydl.ydlcommon.data.http.RxUtils
import com.yidianling.home.constract.IHomeContract
import com.yidianling.home.http.HomeHttp
import com.yidianling.home.model.bean.MuseModuleBean
import io.reactivex.Observable
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述:
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/13
 */
class HomeModelImpl : BaseHomeModelImpl(), IHomeContract.Model {

    /**
     * 首页冥想请求
     */
    override fun museRequest(): Observable<MuseModuleBean> {
        return HomeHttp.getInstance().newMuseRequest().compose(RxUtils.resultJavaData())
            .subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread())
            .onErrorReturn { MuseModuleBean(true) }
    }


}