package com.yidianling.home.ui.view

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import androidx.recyclerview.widget.RecyclerView
import com.ydl.ydl_image.manager.YDLImageCacheManager
import com.yidianling.home.R
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeArticleBean
import kotlinx.android.synthetic.ydl.home_article_item_view.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 文章*阅读模块item
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/14
 */
class HomeArticleItemView(private val mContext: Context, private var homeEvent: IHomeBaseEvent?) :
    LinearLayout(mContext) {

    init {
        initView()
    }

    private fun initView() {
        val params = RecyclerView.LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.WRAP_CONTENT
        )
        layoutParams = params
        View.inflate(mContext, R.layout.home_article_item_view, this)
    }

    fun updateData(bean: HomeArticleBean.Bean?) {
        homeModuleArticleItemViewTitle.text = bean?.title
        homeModuleArticleItemViewContent.text = bean?.desc
        homeModuleArticleItemViewAuthor.text = bean?.name
        homeModuleArticleItemViewGreatNum.text = bean?.countOfFavorite.toString()
        homeModuleArticleItemViewLookNum.text = bean?.readNum.toString()
        YDLImageCacheManager.showImage(mContext, bean?.imgUrl, homeModuleArticleItemViewImg)
        setOnClickListener {
            homeEvent?.articleItemClick(bean)

        }
    }

    /**
     * 最后一个item需要隐藏item的下划线
     */
    fun hideBottomLine() {
        homeModuleArticleItemViewBottomLine.visibility = View.GONE
    }
}