package com.yidianling.home.ui.view

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import androidx.recyclerview.widget.RecyclerView
import com.yidianling.home.R
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.common.tools.RxDeviceTool
import kotlinx.android.synthetic.ydl.home_button_banner_view.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 顶部预约专家，即时倾诉，心理课堂，心理测试按钮模块
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/13
 */
class HomeButtonBannerView(private val mContext: Context, private var homeEvent: IHomeBaseEvent?) : LinearLayout(mContext) {

    private var buttonParams: LinearLayout.LayoutParams? = null

    init {
        initView()
    }

    private fun initView() {
        val params = RecyclerView.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        layoutParams = params
        View.inflate(mContext, R.layout.home_button_banner_view, this)

        initButtonView()

        homeModuleButtonBannerFirst.setOnClickListener {
            homeEvent?.reservationExpertsClick()
        }
        homeModuleButtonBannerSecond.setOnClickListener {
            homeEvent?.nowConfideClick()
        }
        homeModuleButtonBannerThird.setOnClickListener {
            homeEvent?.psychologyClassClick()
        }
        homeModuleButtonBannerFourth.setOnClickListener {
            homeEvent?.psychologyTestClick()
        }
    }

    /**
     * 初始化四个按钮
     */
    private fun initButtonView() {
        if (null == buttonParams) {
            var screenWidth = RxDeviceTool.getScreenWidth(mContext)
            var viewWidth = ((screenWidth - 2 * 9 * RxDeviceTool.getScreenDensity(mContext)) / 4).toInt()
            var viewHeight = viewWidth * 78 / 80
            buttonParams = LinearLayout.LayoutParams(viewWidth, viewHeight)
            homeModuleButtonBannerFirst.layoutParams = buttonParams
            homeModuleButtonBannerSecond.layoutParams = buttonParams
            homeModuleButtonBannerThird.layoutParams = buttonParams
            homeModuleButtonBannerFourth.layoutParams = buttonParams
        }
    }
}