package com.yidianling.home.ui.view

import android.content.Context
import android.view.View
import android.widget.LinearLayout
import com.yidianling.home.R
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeTestItemBean
import com.ydl.ydl_image.config.ISimpleImageOpConfig
import com.ydl.ydl_image.config.SimpleImageOpConfiger
import com.ydl.ydl_image.manager.YDLImageCacheManager
import com.yidianling.common.tools.RxDeviceTool
import com.yidianling.common.tools.RxImageTool
import kotlinx.android.synthetic.ydl.home_test_top_item_view.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 测试*分析模块item--顶部item
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/15
 */
class HomeTestTopItemView(private val mContext: Context, private var homeEvent: IHomeBaseEvent?): LinearLayout(mContext) {

    init {
        initView()
    }

    private fun initView() {
        orientation = VERTICAL

        var screenWidth = RxDeviceTool.getScreenWidth(mContext)
        var viewWidth = (screenWidth - 2 * 15 * RxDeviceTool.getScreenDensity(mContext)).toInt()
        var viewHeight = viewWidth * 143 / 345
        val params = LinearLayout.LayoutParams(viewWidth, viewHeight)
        layoutParams = params
        View.inflate(mContext, R.layout.home_test_top_item_view, this)

    }

    /**
     * 刷新数据
     */
    fun updateData(bean: HomeTestItemBean) {
        var screenWidth = RxDeviceTool.getScreenWidth(mContext)
        var viewWidth = (screenWidth - RxImageTool.dip2px(30f))
        var viewHeight = viewWidth * 143 / 345
        val sp = SimpleImageOpConfiger()
        sp.loadingPic = R.drawable.platform_default_img
        sp.errorPic = R.drawable.platform_default_img
        sp.scaleType = ISimpleImageOpConfig.CENTER_CROP
        sp.isCacheOnDisk = true
        YDLImageCacheManager.showImage(mContext,bean?.shareImage,homeModuleIntelligentTopViewImage, viewWidth, viewHeight,sp)

        homeModuleIntelligentTopViewTitle.text = bean.name
        homeModuleIntelligentTopViewHits.text = bean.testNum.toString()

        this.setOnClickListener{
            homeEvent?.testItemClick(bean.recommendLinkUrl)
        }
    }
}