package com.yidianling.im.http

import com.ydl.ydlcommon.base.config.YDL_DOMAIN
import com.ydl.ydlcommon.base.config.YDL_DOMAIN_JAVA
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlnet.YDLHttpUtils
import com.yidianling.im.api.bean.IMExpertBuild
import com.yidianling.im.bean.*
import io.reactivex.Observable
import okhttp3.RequestBody
import retrofit2.http.*

/**
 * im相关网络接口
 * Created by hrvie on 17-11-24.
 */
interface ImRetrofitApi {

    companion object {
        var instance: ImRetrofitApi? = null

        fun getImRetrofitApi(): ImRetrofitApi {
            if (instance == null) {
                instance = YDLHttpUtils.obtainApi(ImRetrofitApi::class.java)
            }
            return instance!!
        }

        fun getImJavaApi(): ImRetrofitApi {
            return YDLHttpUtils.obtainApi(ImRetrofitApi::class.java)
        }
    }

    //私聊 获取聊天者的订单关系数据
    @FormUrlEncoded
    @POST("consult/get-expert")
    fun getExpert(@FieldMap params: Map<String, String>): Observable<BaseResponse<IMExpertBuild>>


    //获取用户的状态（用户、专家、助理）
    @GET("user/userType")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getUserType(@Query("targetUid") uid: String): Observable<BaseResponse<UserTypeBean>>

    //根据专家uid获取私聊的目标uid（有可能是专家uid，有可能是助理uid）
    @GET("consult/assistant/chat-user")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getChatUid(@Query("doctorUid") uid: String): Observable<BaseAPIResponse<DoctorAssistantRespDtoBean>>

    //私聊 获取聊天者的订单关系数据   -----进入聊天前调用的接口，采用新的java接口，直接php  getExpert 接口废弃
    @GET("doctor/personalChat")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getPersonalChat(@Query("doctorUid") doctorUid: String): Observable<BaseResponse<IMExpertBuild>>

    //获取举报理由
    @FormUrlEncoded
    @POST("ask/report-reason")
    fun getReportReason(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    //举报心事或者心事回复(动态)
    @FormUrlEncoded
    @POST("ask/report")
    fun reportWorry(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    //删除私聊记录
    @FormUrlEncoded
    @POST("consult/rm-history")
    fun rmHistory(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    //加入黑名单
    @FormUrlEncoded
    @POST("consult/set-black")
    fun setBlackCall(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    //从黑名单移除
    @FormUrlEncoded
    @POST("consult/rm-black")
    fun rmBlackCall(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    //红包详情
    @FormUrlEncoded
    @POST("uc/bonus-info")
    fun redPacketDetail(@FieldMap params: Map<String, String>): Observable<BaseResponse<RedPacketDetailBean>>

    //设置课程直播状态
    @POST("course/set-live-status")
    @FormUrlEncoded
    fun setCourseStatus(@FieldMap maps: Map<String, String>): Observable<BaseResponse<Any>>

    //获取课程直播状态
    @POST("course/get-live-status")
    @FormUrlEncoded
    fun getCourseStatus(@FieldMap maps: Map<String, String>): Observable<BaseResponse<CourseStatusBean>>

    /**
     * 私聊更多按钮 - 推荐倾诉 - by :洪平
     * @param uid
     * @param listenerUid
     * @return
     */
    @GET("chat/pushServeStatus")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getPushConfideStatus(
        @Query("uid") uid: String,
        @Query("listenerUid") listenerUid: String
    ): Observable<BaseAPIResponse<PushConfideStatusBean>>

    @POST("lingxi/asistant/buryRedPoint")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun imBuryRedPoints(@Body body: RequestBody): Observable<BaseAPIResponse<Any>>

    /**确认订单 */
    @POST("counselor/order/standardOrderServiceOperation")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun standardOrderServiceOperation(@Body body: RequestBody): Observable<BaseAPIResponse<Any>>

    /**已完成订单*/
    @GET("consult/user/order/affirmComplete")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun affirmComplete( @Query("id") orderId: String): Observable<BaseAPIResponse<Any>>

    //回答问题接口
    @POST("chat/sendCustomizeMessage")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun lingxiAnswerQuestion(@Body body: RequestBody): Observable<BaseAPIResponse<Any>>

    //发送通知接口
    @POST("chat/sendNoticeMessage")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun lingxiSendNotice(@Body body: RequestBody): Observable<BaseAPIResponse<Any>>


    /**已完成订单*/
    @GET("systemconfig/getSystemConfigByKeyword")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getSystemConfigByKeyword( @Query("keyword") keyword: String): Observable<BaseAPIResponse<SystemConfigByKeywordBean>>
}