package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yidianling.common.tools.LogUtil;
import com.yidianling.im.session.viewholder.bean.LingxiWhichQuestionBean;
import com.yidianling.im.session.viewholder.bean.QuestionItemBean;
import com.yidianling.uikit.custom.http.response.RecommendExpertBean;

import java.util.ArrayList;
import java.util.List;

public class CustomAttachLingxiWhichQuestion extends CustomAttachment {
    private final String QUESTIONPAPERID = "questionPaperId";//试卷id
    private final String TYPE = "type";//选项类型：radio单选，check多选
    private final String OPTIONS = "options";//选项
    private final String EXAMID="examId";//考试ID
    private final String ID="id";//id
    private final String NAME="name";//name



    public String questionPaperId;
    public String type;
    public List<QuestionItemBean> options;
    public String examId;
    public String id;
    public String name;
    public CustomAttachLingxiWhichQuestion() {
        super(CustomAttachmentType.TYPE_LINGXI_WHICH_QUESTION);
    }

    @Override
    protected void parseData(JSONObject data) {
        this.questionPaperId = data.getString(QUESTIONPAPERID);
        this.type = data.getString(TYPE);
        this.examId = data.getString(EXAMID);
        this.id = data.getString(ID);
        this.name = data.getString(NAME);
        this.options=(ArrayList<QuestionItemBean>)JSON.parseArray(data.getString(OPTIONS), QuestionItemBean.class);

    }

    @Override
    protected JSONObject packData() {
        JSONObject data = new JSONObject();
        data.put(QUESTIONPAPERID, questionPaperId);
        data.put(TYPE,type);
        data.put(OPTIONS, options);
        data.put(EXAMID, examId);
        data.put(ID, id);
        data.put(NAME, name);
        return data;
    }

}
